/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.util;

import io.dekorate.crd.annotation.Status;
import io.dekorate.crd.config.CustomResourceConfig;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.AnnotationRefBuilder;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.TypeUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.TypeElement;

public class Types {
    private static final TypeDef NAMESPACED = (TypeDef)ClassTo.TYPEDEF.apply(Namespaced.class);
    private static final Predicate<AnnotationRefBuilder> predicate = new Predicate<AnnotationRefBuilder>(){

        @Override
        public boolean test(AnnotationRefBuilder ref) {
            return ref.getClassRef().getName().equals("SpecReplicas");
        }
    };

    public static boolean isNamespaced(TypeDef definition) {
        return Types.isNamespaced(definition, new HashSet<TypeDef>());
    }

    public static boolean isNamespaced(TypeDef definition, Set<TypeDef> visited) {
        if (definition.getFullyQualifiedName().equals(NAMESPACED.getFullyQualifiedName())) {
            return true;
        }
        if (visited.contains(definition) || definition.getPackageName().startsWith("java.")) {
            return false;
        }
        HashSet<TypeDef> newVisited = new HashSet<TypeDef>(visited);
        newVisited.add(definition);
        for (ClassRef i : definition.getImplementsList()) {
            if (!Types.isNamespaced(i.getDefinition(), newVisited)) continue;
            return true;
        }
        for (ClassRef e : definition.getExtendsList()) {
            if (!Types.isNamespaced(e.getDefinition(), newVisited)) continue;
            return true;
        }
        return false;
    }

    public static Optional<TypeRef> findStatusType(CustomResourceConfig config, TypeDef typeDef) {
        if (!CustomResourceConfig.AUTODETECT.equals(config.getStatusClassName())) {
            try {
                TypeElement statusElement = CodegenContext.getContext().getElements().getTypeElement(config.getStatusClassName());
                return Optional.of(((TypeDef)ElementTo.TYPEDEF.apply((Object)statusElement)).toReference(new TypeRef[0]));
            }
            catch (Exception statusElement) {
                try {
                    return Optional.of(((TypeDef)ClassTo.TYPEDEF.apply(Class.forName(config.getStatusClassName()))).toReference(new TypeRef[0]));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class " + config.getStatusClassName() + " could not be found neither in the compilation unit, nor in the classpath!", e);
                }
            }
        }
        return Types.findStatusProperty(config, typeDef).map(Property::getTypeRef);
    }

    public static Optional<Property> findStatusProperty(CustomResourceConfig config, TypeDef typeDef) {
        return TypeUtils.allProperties((TypeDef)typeDef).stream().filter(Types::isStatusProperty).findFirst();
    }

    public static boolean isStatusProperty(Property property) {
        return "status".equals(property.getName()) || property.getAnnotations().stream().anyMatch(a -> Status.class.getName().equals(a.getClassRef().getFullyQualifiedName()));
    }

    public void getSpecReplicasPath(TypeDef def, List<String> path, List<String> visited) {
        for (Property p : def.getProperties()) {
            if (!p.getAnnotations().stream().anyMatch(a -> a.getClassRef().getName().equals("SpecReplicas"))) continue;
        }
    }
}

