/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.handler;

import io.dekorate.Handler;
import io.dekorate.Resources;
import io.dekorate.crd.annotation.Autodetect;
import io.dekorate.crd.config.CustomResourceConfig;
import io.dekorate.crd.config.EditableCustomResourceConfig;
import io.dekorate.crd.config.Keys;
import io.dekorate.crd.config.Scale;
import io.dekorate.crd.decorator.AddAdditionPrinterColumnDecorator;
import io.dekorate.crd.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.dekorate.crd.decorator.AddCustomResourceDefintionVersionDecorator;
import io.dekorate.crd.decorator.AddLabelSelectorPathDecorator;
import io.dekorate.crd.decorator.AddSchemaToCustomResourceDefinitionVersionDecorator;
import io.dekorate.crd.decorator.AddSpecReplicasPathDecorator;
import io.dekorate.crd.decorator.AddStatusReplicasPathDecorator;
import io.dekorate.crd.decorator.AddStatusSubresourceDecorator;
import io.dekorate.crd.decorator.AddSubresourcesDecorator;
import io.dekorate.crd.decorator.EnsureSingleStorageVersionDecorator;
import io.dekorate.crd.decorator.PromoteSingleVersionAttributesDecorator;
import io.dekorate.crd.decorator.SetServedVersionDecorator;
import io.dekorate.crd.decorator.SetStorageVersionDecorator;
import io.dekorate.crd.util.JsonSchema;
import io.dekorate.crd.util.Types;
import io.dekorate.crd.visitor.AdditionalPrineterColumnDetector;
import io.dekorate.crd.visitor.LabelSelectorPathDetector;
import io.dekorate.crd.visitor.SpecReplicasPathDetector;
import io.dekorate.crd.visitor.StatusReplicasPathDetector;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.sundr.builder.Visitor;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeDefFluent;
import io.sundr.codegen.model.TypeRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public class CustomResourceHandler
implements Handler<CustomResourceConfig> {
    private final Resources resources;

    public CustomResourceHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 400;
    }

    public String getKey() {
        return "crd";
    }

    public void handle(CustomResourceConfig config) {
        TypeDef def = (TypeDef)config.getAttribute(Keys.TYPE_DEFINITION);
        String name = config.getPlural() + "." + config.getGroup();
        String version = config.getVersion();
        Optional<TypeRef> statusType = Types.findStatusType(config, def);
        SpecReplicasPathDetector specReplicasPathDetector = new SpecReplicasPathDetector();
        StatusReplicasPathDetector statusReplicasPathDetector = new StatusReplicasPathDetector();
        LabelSelectorPathDetector labalSelectorPathDetector = new LabelSelectorPathDetector();
        AdditionalPrineterColumnDetector additionalPrineterColumnDetector = new AdditionalPrineterColumnDetector();
        StatusReplicasPathDetector externalStatusReplicasPathDetector = new StatusReplicasPathDetector(".spec.");
        LabelSelectorPathDetector externalLabalSelectorPathDetector = new LabelSelectorPathDetector(".spec.");
        AdditionalPrineterColumnDetector externalAdditionalPrineterColumnDetector = new AdditionalPrineterColumnDetector(".spec.");
        if (statusType.isPresent()) {
            TypeDef externalStatusDef;
            TypeElement externalStatusElement;
            ClassRef externalStatusRef;
            TypeDefBuilder builder = new TypeDefBuilder(def);
            Optional<Property> statusProperty = Types.findStatusProperty(config, def);
            statusProperty.ifPresent(p -> builder.removeFromProperties(new Property[]{p}));
            def = ((TypeDefBuilder)((TypeDefFluent.PropertiesNested)((TypeDefFluent.PropertiesNested)builder.addNewProperty().withName("status")).withTypeRef(statusType.get())).endProperty()).build();
            if (Strings.isNotNullOrEmpty((String)config.getStatusClassName()) && (externalStatusRef = ((TypeDef)ElementTo.TYPEDEF.apply((Object)(externalStatusElement = CodegenContext.getContext().getElements().getTypeElement(config.getStatusClassName())))).toReference(new TypeRef[0])) instanceof ClassRef && (externalStatusDef = externalStatusRef.getDefinition()).getName().equals(Autodetect.class.getSimpleName())) {
                ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(externalStatusDef).accept(new Visitor[]{externalStatusReplicasPathDetector})).accept(new Visitor[]{externalLabalSelectorPathDetector})).accept(new Visitor[]{externalAdditionalPrineterColumnDetector})).build();
            }
        }
        def = ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(def).accept(new Visitor[]{specReplicasPathDetector})).accept(new Visitor[]{statusReplicasPathDetector})).accept(new Visitor[]{labalSelectorPathDetector})).accept(new Visitor[]{additionalPrineterColumnDetector})).build();
        if (this.resources.groups().isEmpty() && this.resources.global().getItems().isEmpty()) {
            this.resources.add((HasMetadata)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion("apiextensions.k8s.io/v1beta1")).withNewMetadata().withName(name)).endMetadata()).withNewSpec().withScope(config.getScope().name())).withGroup(config.getGroup())).withNewNames().withKind(config.getKind())).withShortNames(new String[]{config.getShortName()})).withPlural(config.getPlural())).withSingular(config.getKind().toLowerCase())).endNames()).endSpec()).build());
        } else {
            this.resources.decorate((Decorator)new AddCustomResourceDefinitionResourceDecorator(name, config.getGroup(), config.getKind(), config.getScope().name(), config.getShortName(), config.getPlural(), config.getKind().toLowerCase()));
        }
        this.resources.decorate((Decorator)new AddCustomResourceDefintionVersionDecorator(name, version));
        this.resources.decorate((Decorator)new AddSchemaToCustomResourceDefinitionVersionDecorator(name, version, JsonSchema.from(def, "kind", "apiVersion", "metadata")));
        String specReplicasPath = Strings.isNotNullOrEmpty((String)config.getScale().getSpecReplicasPath()) ? config.getScale().getSpecReplicasPath() : (String)specReplicasPathDetector.getPath().orElse(null);
        String statusReplicasPath = Strings.isNotNullOrEmpty((String)config.getScale().getStatusReplicasPath()) ? config.getScale().getStatusReplicasPath() : (String)statusReplicasPathDetector.getPath().orElse(externalStatusReplicasPathDetector.getPath().orElse(null));
        String labalSelectorPath = Strings.isNotNullOrEmpty((String)config.getScale().getLabelSelectorPath()) ? config.getScale().getLabelSelectorPath() : (String)labalSelectorPathDetector.getPath().orElse(externalLabalSelectorPathDetector.getPath().orElse(null));
        HashMap<String, Property> additionalPrinterColumns = new HashMap<String, Property>();
        additionalPrinterColumns.putAll(additionalPrineterColumnDetector.getProperties());
        additionalPrinterColumns.putAll(externalAdditionalPrineterColumnDetector.getProperties());
        if (Strings.isNotNullOrEmpty((String)specReplicasPath)) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name, version));
            this.resources.decorate((Decorator)new AddSpecReplicasPathDecorator(name, version, specReplicasPath));
        }
        if (Strings.isNotNullOrEmpty((String)statusReplicasPath)) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name, version));
            this.resources.decorate((Decorator)new AddStatusReplicasPathDecorator(name, version, statusReplicasPath));
        }
        if (Strings.isNotNullOrEmpty((String)labalSelectorPath)) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name, version));
            this.resources.decorate((Decorator)new AddLabelSelectorPathDecorator(name, version, labalSelectorPath));
        }
        if (statusType.isPresent()) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name, version));
            this.resources.decorate((Decorator)new AddStatusSubresourceDecorator(name, version));
        }
        this.resources.decorate((Decorator)new SetServedVersionDecorator(name, version, config.isServed()));
        this.resources.decorate((Decorator)new SetStorageVersionDecorator(name, version, config.isStorage()));
        this.resources.decorate((Decorator)new EnsureSingleStorageVersionDecorator(name));
        this.resources.decorate((Decorator)new PromoteSingleVersionAttributesDecorator(name));
        additionalPrinterColumns.forEach((path, property) -> {
            Map parameters = property.getAnnotations().stream().filter(a -> a.getClassRef().getName().equals("PrinterColumn")).map(a -> a.getParameters()).findFirst().orElse(Collections.emptyMap());
            String type = JsonSchema.TYPE_MAP.getOrDefault(property.getTypeRef(), "object");
            String column = (String)parameters.get("name");
            if (Strings.isNullOrEmpty((String)column)) {
                column = property.getName().toUpperCase();
            }
            String description = property.getComments().stream().filter(l -> !l.trim().startsWith("@")).collect(Collectors.joining(" ")).trim();
            String format = (String)parameters.get("format");
            this.resources.decorate((Decorator)new AddAdditionPrinterColumnDecorator(name, version, type, column, (String)path, format, description));
        });
    }

    public boolean canHandle(Class<? extends Configuration> config) {
        return CustomResourceConfig.class.equals(config) || EditableCustomResourceConfig.class.equals(config);
    }

    protected static boolean hasNonDefaultScaleConfig(Scale scale) {
        return Strings.isNotNullOrEmpty((String)scale.getSpecReplicasPath()) || Strings.isNotNullOrEmpty((String)scale.getStatusReplicasPath()) || Strings.isNotNullOrEmpty((String)scale.getLabelSelectorPath());
    }
}

