/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.configurator;

import io.dekorate.crd.config.CustomResourceConfigBuilder;
import io.dekorate.crd.util.CamelCase;
import io.dekorate.crd.util.Pluralize;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.utils.Strings;

public class AddClassNameConfigurator
extends Configurator<CustomResourceConfigBuilder> {
    private final String className;

    public AddClassNameConfigurator(String className) {
        this.className = className;
    }

    public void visit(CustomResourceConfigBuilder customResourceConfig) {
        if (Strings.isNullOrEmpty((String)customResourceConfig.getName())) {
            customResourceConfig.withName(CamelCase.TO_DASH_SEPARATED.andThen(String::toLowerCase).apply(this.className));
        }
        if (Strings.isNullOrEmpty((String)customResourceConfig.getKind())) {
            customResourceConfig.withKind(this.className);
        }
        if (Strings.isNullOrEmpty((String)customResourceConfig.getPlural())) {
            customResourceConfig.withPlural(Pluralize.FUNCTION.andThen(String::toLowerCase).apply(this.className));
        }
        if (Strings.isNullOrEmpty((String)customResourceConfig.getShortName())) {
            customResourceConfig.withShortName(CamelCase.TO_SHORTNAME.apply(this.className));
        }
    }
}

