/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.decorator;

import io.dekorate.crd.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.dekorate.crd.decorator.AddCustomResourceDefintionVersionDecorator;
import io.dekorate.crd.decorator.CustomResourceDefinitionDecorator;
import io.dekorate.crd.decorator.SetStorageVersionDecorator;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecFluent;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersion;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersionBuilder;
import io.dekorate.kubernetes.decorator.Decorator;
import java.util.concurrent.atomic.AtomicReference;

public class EnsureSingleStorageVersionDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    private final AtomicReference<String> storageVersion = new AtomicReference();

    public EnsureSingleStorageVersionDecorator(String name) {
        super(name);
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        Predicate<CustomResourceDefinitionVersionBuilder> hasStorageVersion = new Predicate<CustomResourceDefinitionVersionBuilder>(){

            public Boolean apply(CustomResourceDefinitionVersionBuilder version) {
                return version.isStorage();
            }
        };
        if (spec.hasVersions().booleanValue() && !spec.hasMatchingVersion((Predicate)hasStorageVersion).booleanValue()) {
            System.out.println("Only one version found... Setting to storage!");
            ((CustomResourceDefinitionSpecFluent.VersionsNested)spec.editFirstVersion().withStorage(Boolean.valueOf(true))).endVersion();
        }
        for (CustomResourceDefinitionVersion version : spec.buildVersions()) {
            if (!version.getStorage().booleanValue()) continue;
            String existing = this.storageVersion.get();
            if (existing != null && !existing.equals(version.getName())) {
                throw new IllegalStateException(String.format("Version %s is marked as storage and so is %s. Only one version should be marked as storage per custom resource.", version.getName(), existing));
            }
            this.storageVersion.set(version.getName());
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class, AddCustomResourceDefintionVersionDecorator.class, SetStorageVersionDecorator.class};
    }
}

