package io.dekorate.crd.config;

import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.StringBuilder;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;
import io.dekorate.project.Project;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CustomResourceConfigFluent<A extends CustomResourceConfigFluent<A>> extends ConfigurationFluent<A> {


    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public A withNewGroup(String arg1);
    public A withNewGroup(StringBuilder arg1);
    public A withNewGroup(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getPlural();
    public A withPlural(String plural);
    public Boolean hasPlural();
    public A withNewPlural(String arg1);
    public A withNewPlural(StringBuilder arg1);
    public A withNewPlural(StringBuffer arg1);
    public String getShortName();
    public A withShortName(String shortName);
    public Boolean hasShortName();
    public A withNewShortName(String arg1);
    public A withNewShortName(StringBuilder arg1);
    public A withNewShortName(StringBuffer arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public boolean isServed();
    public A withServed(boolean served);
    public Boolean hasServed();
    public boolean isStorage();
    public A withStorage(boolean storage);
    public Boolean hasStorage();
    public Scope getScope();
    public A withScope(Scope scope);
    public Boolean hasScope();
    
/**
 * This method has been deprecated, please use method buildScale instead.
 * @return The buildable object.
 */
@Deprecated public Scale getScale();
    public Scale buildScale();
    public A withScale(Scale scale);
    public Boolean hasScale();
    public A withNewScale(String specReplicasPath,String statusReplicasPath,String labelSelectorPath);
    public CustomResourceConfigFluent.ScaleNested<A> withNewScale();
    public CustomResourceConfigFluent.ScaleNested<A> withNewScaleLike(Scale item);
    public CustomResourceConfigFluent.ScaleNested<A> editScale();
    public CustomResourceConfigFluent.ScaleNested<A> editOrNewScale();
    public CustomResourceConfigFluent.ScaleNested<A> editOrNewScaleLike(Scale item);
    public String getStatusClassName();
    public A withStatusClassName(String statusClassName);
    public Boolean hasStatusClassName();
    public A withNewStatusClassName(String arg1);
    public A withNewStatusClassName(StringBuilder arg1);
    public A withNewStatusClassName(StringBuffer arg1);
    public interface ScaleNested<N> extends Nested<N>,ScaleFluent<CustomResourceConfigFluent.ScaleNested<N>> {

        public N and();
        public N endScale();    }


}
