package io.dekorate.crd.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceConfigBuilder extends CustomResourceConfigFluentImpl<CustomResourceConfigBuilder> implements VisitableBuilder<CustomResourceConfig,CustomResourceConfigBuilder> {

    CustomResourceConfigFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceConfigBuilder() { 
        this(true);
    }


    public CustomResourceConfigBuilder(Boolean validationEnabled) { 
        this(new CustomResourceConfig(), validationEnabled);
    }


    public CustomResourceConfigBuilder(CustomResourceConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public CustomResourceConfigBuilder(CustomResourceConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CustomResourceConfig(), validationEnabled);
    }


    public CustomResourceConfigBuilder(CustomResourceConfigFluent<?> fluent,CustomResourceConfig instance) { 
        this(fluent, instance, true);
    }


    public CustomResourceConfigBuilder(CustomResourceConfigFluent<?> fluent,CustomResourceConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withProject(instance.getProject()); 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withGroup(instance.getGroup()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withPlural(instance.getPlural()); 
        fluent.withShortName(instance.getShortName()); 
        fluent.withVersion(instance.getVersion()); 
        fluent.withServed(instance.isServed()); 
        fluent.withStorage(instance.isStorage()); 
        fluent.withScope(instance.getScope()); 
        fluent.withScale(instance.getScale()); 
        fluent.withStatusClassName(instance.getStatusClassName()); 
        this.validationEnabled = validationEnabled; 
    }


    public CustomResourceConfigBuilder(CustomResourceConfig instance) { 
        this(instance,true);
    }


    public CustomResourceConfigBuilder(CustomResourceConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withPlural(instance.getPlural()); 
        this.withShortName(instance.getShortName()); 
        this.withVersion(instance.getVersion()); 
        this.withServed(instance.isServed()); 
        this.withStorage(instance.isStorage()); 
        this.withScope(instance.getScope()); 
        this.withScale(instance.getScale()); 
        this.withStatusClassName(instance.getStatusClassName()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.dekorate.crd.config.EditableCustomResourceConfig build() {
        EditableCustomResourceConfig buildable = new EditableCustomResourceConfig(fluent.getProject(),fluent.getAttributes(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getPlural(),fluent.getShortName(),fluent.getVersion(),fluent.isServed(),fluent.isStorage(),fluent.getScope(),fluent.getScale(),fluent.getStatusClassName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceConfigBuilder that = (CustomResourceConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
