/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.handler;

import io.dekorate.Handler;
import io.dekorate.Resources;
import io.dekorate.crd.annotation.Autodetect;
import io.dekorate.crd.config.CustomResourceConfig;
import io.dekorate.crd.config.EditableCustomResourceConfig;
import io.dekorate.crd.config.Keys;
import io.dekorate.crd.config.Scale;
import io.dekorate.crd.decorator.AddLabelSelectorPathDecorator;
import io.dekorate.crd.decorator.AddSpecReplicasPathDecorator;
import io.dekorate.crd.decorator.AddStatusReplicasPathDecorator;
import io.dekorate.crd.decorator.AddStatusSubresourceDecorator;
import io.dekorate.crd.decorator.AddSubresourcesDecorator;
import io.dekorate.crd.util.JsonSchema;
import io.dekorate.crd.util.Types;
import io.dekorate.crd.visitor.LabelSelectorPathDetector;
import io.dekorate.crd.visitor.SpecReplicasPathDetector;
import io.dekorate.crd.visitor.StatusReplicasPathDetector;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluent;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecFluent;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Strings;
import io.sundr.builder.Visitor;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeDefFluent;
import io.sundr.codegen.model.TypeRef;
import java.util.Optional;
import javax.lang.model.element.TypeElement;

public class CustomResourceHandler
implements Handler<CustomResourceConfig> {
    private final Resources resources;

    public CustomResourceHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 400;
    }

    public void handle(CustomResourceConfig config) {
        String labalSelectorPath;
        TypeDef def = (TypeDef)config.getAttribute(Keys.TYPE_DEFINITION);
        String name = config.getPlural() + "." + config.getGroup();
        Optional<TypeRef> statusType = Types.findStatusType(config, def);
        SpecReplicasPathDetector specReplicasPathDetector = new SpecReplicasPathDetector();
        StatusReplicasPathDetector statusReplicasPathDetector = new StatusReplicasPathDetector();
        LabelSelectorPathDetector labalSelectorPathDetector = new LabelSelectorPathDetector();
        StatusReplicasPathDetector externalStatusReplicasPathDetector = new StatusReplicasPathDetector(".spec.");
        LabelSelectorPathDetector externalLabalSelectorPathDetector = new LabelSelectorPathDetector(".spec.");
        if (statusType.isPresent()) {
            TypeDef externalStatusDef;
            TypeElement externalStatusElement;
            ClassRef externalStatusRef;
            TypeDefBuilder builder = new TypeDefBuilder(def);
            Optional<Property> statusProperty = Types.findStatusProperty(config, def);
            statusProperty.ifPresent(p -> builder.removeFromProperties(new Property[]{p}));
            def = ((TypeDefBuilder)((TypeDefFluent.PropertiesNested)((TypeDefFluent.PropertiesNested)builder.addNewProperty().withName("status")).withTypeRef(statusType.get())).endProperty()).build();
            if (Strings.isNotNullOrEmpty((String)config.getStatusClassName()) && (externalStatusRef = ((TypeDef)ElementTo.TYPEDEF.apply((Object)(externalStatusElement = CodegenContext.getContext().getElements().getTypeElement(config.getStatusClassName())))).toReference(new TypeRef[0])) instanceof ClassRef && (externalStatusDef = externalStatusRef.getDefinition()).getName().equals(Autodetect.class.getSimpleName())) {
                ((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(externalStatusDef).accept((Visitor)externalStatusReplicasPathDetector)).accept((Visitor)externalLabalSelectorPathDetector)).build();
            }
        }
        def = ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(def).accept((Visitor)specReplicasPathDetector)).accept((Visitor)statusReplicasPathDetector)).accept((Visitor)labalSelectorPathDetector)).build();
        this.resources.add((HasMetadata)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.ValidationNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion("apiextensions.k8s.io/v1beta1")).withNewMetadata().withName(name)).endMetadata()).withNewSpec().withScope(config.getScope().name())).withGroup(config.getGroup())).withVersion(config.getVersion())).withNewNames().withKind(config.getKind())).withShortNames(new String[]{config.getShortName()})).withPlural(config.getPlural())).withSingular(config.getKind().toLowerCase())).endNames()).withNewValidation().withOpenAPIV3Schema(JsonSchema.from(def))).endValidation()).endSpec()).build());
        String specReplicasPath = Strings.isNotNullOrEmpty((String)config.getScale().getSpecReplicasPath()) ? config.getScale().getSpecReplicasPath() : (String)specReplicasPathDetector.getPath().orElse(null);
        String statusReplicasPath = Strings.isNotNullOrEmpty((String)config.getScale().getStatusReplicasPath()) ? config.getScale().getStatusReplicasPath() : (String)statusReplicasPathDetector.getPath().orElse(externalStatusReplicasPathDetector.getPath().orElse(null));
        String string = labalSelectorPath = Strings.isNotNullOrEmpty((String)config.getScale().getLabelSelectorPath()) ? config.getScale().getLabelSelectorPath() : (String)labalSelectorPathDetector.getPath().orElse(externalLabalSelectorPathDetector.getPath().orElse(null));
        if (Strings.isNotNullOrEmpty((String)specReplicasPath)) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name));
            this.resources.decorate((Decorator)new AddSpecReplicasPathDecorator(name, specReplicasPath));
        }
        if (Strings.isNotNullOrEmpty((String)statusReplicasPath)) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name));
            this.resources.decorate((Decorator)new AddStatusReplicasPathDecorator(name, statusReplicasPath));
        }
        if (Strings.isNotNullOrEmpty((String)labalSelectorPath)) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name));
            this.resources.decorate((Decorator)new AddLabelSelectorPathDecorator(name, labalSelectorPath));
        }
        if (statusType.isPresent()) {
            this.resources.decorate((Decorator)new AddSubresourcesDecorator(name));
            this.resources.decorate((Decorator)new AddStatusSubresourceDecorator(name));
        }
    }

    public boolean canHandle(Class<? extends Configuration> config) {
        return CustomResourceConfig.class.equals(config) || EditableCustomResourceConfig.class.equals(config);
    }

    protected static boolean hasNonDefaultScaleConfig(Scale scale) {
        return Strings.isNotNullOrEmpty((String)scale.getSpecReplicasPath()) || Strings.isNotNullOrEmpty((String)scale.getStatusReplicasPath()) || Strings.isNotNullOrEmpty((String)scale.getLabelSelectorPath());
    }
}

