package io.dekorate.crd.config;

import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.StringBuffer;
import io.dekorate.crd.confg.Scope;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CustomResourceConfigFluentImpl<A extends CustomResourceConfigFluent<A>> extends ConfigurationFluentImpl<A> implements CustomResourceConfigFluent<A> {

    private String group = "";
    private String kind = "";
    private String name = "";
    private String plural = "";
    private String shortName = "";
    private String version = "";
    private Scope scope = io.dekorate.crd.confg.Scope.Namespaced;

    public CustomResourceConfigFluentImpl() { 
    }


    public CustomResourceConfigFluentImpl(CustomResourceConfig instance) { 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withPlural(instance.getPlural()); 
        this.withShortName(instance.getShortName()); 
        this.withVersion(instance.getVersion()); 
        this.withScope(instance.getScope()); 
    }


    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getPlural() {
        return this.plural;
    }

    public A withPlural(String plural) {
        this.plural=plural; return (A) this;
    }

    public Boolean hasPlural() {
        return this.plural != null;
    }

    public A withNewPlural(String arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A withNewPlural(StringBuilder arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A withNewPlural(StringBuffer arg1) {
        return (A)withPlural(new String(arg1));
    }

    public String getShortName() {
        return this.shortName;
    }

    public A withShortName(String shortName) {
        this.shortName=shortName; return (A) this;
    }

    public Boolean hasShortName() {
        return this.shortName != null;
    }

    public A withNewShortName(String arg1) {
        return (A)withShortName(new String(arg1));
    }

    public A withNewShortName(StringBuilder arg1) {
        return (A)withShortName(new String(arg1));
    }

    public A withNewShortName(StringBuffer arg1) {
        return (A)withShortName(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public Scope getScope() {
        return this.scope;
    }

    public A withScope(Scope scope) {
        this.scope=scope; return (A) this;
    }

    public Boolean hasScope() {
        return this.scope != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceConfigFluentImpl that = (CustomResourceConfigFluentImpl) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (plural != null ? !plural.equals(that.plural) :that.plural != null) return false;
        if (shortName != null ? !shortName.equals(that.shortName) :that.shortName != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  kind,  name,  plural,  shortName,  version,  scope,  super.hashCode());
    }

}
