package io.dekorate.crd.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.crd.confg.Scope;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class CustomResourceConfig extends Configuration {

    private String group = "";
    private String kind = "";
    private String name = "";
    private String plural = "";
    private String shortName = "";
    private String version = "";
    private Scope scope = io.dekorate.crd.confg.Scope.Namespaced;

    public CustomResourceConfig() { 
    }


    public CustomResourceConfig(Project project,Map<ConfigKey,Object> attributes,String group,String kind,String name,String plural,String shortName,String version,Scope scope) { 
        super(project, attributes);
        this.group = group != null ? group : "";
        this.kind = kind != null ? kind : "";
        this.name = name != null ? name : "";
        this.plural = plural != null ? plural : "";
        this.shortName = shortName != null ? shortName : "";
        this.version = version != null ? version : "";
        this.scope = scope != null ? scope : io.dekorate.crd.confg.Scope.Namespaced;
    }


    public String getGroup() {
        return this.group;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getVersion() {
        return this.version;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceConfig that = (CustomResourceConfig) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (plural != null ? !plural.equals(that.plural) :that.plural != null) return false;
        if (shortName != null ? !shortName.equals(that.shortName) :that.shortName != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  kind,  name,  plural,  shortName,  version,  scope,  super.hashCode());
    }

}
