package io.dekorate.crd.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.crd.confg.Scope;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class CustomResourceConfig extends Configuration{

    private String group = "";
    private String kind = "";
    private String name = "";
    private String plural = "";
    private String shortName = "";
    private String version = "";
    private Scope scope = io.dekorate.crd.confg.Scope.Namespaced;

    public CustomResourceConfig(){
    }
    public CustomResourceConfig(Project project,Map<ConfigKey,Object> attributes,String group,String kind,String name,String plural,String shortName,String version,Scope scope){
            super(project, attributes);
            this.group = group != null ? group : "";
            this.kind = kind != null ? kind : "";
            this.name = name != null ? name : "";
            this.plural = plural != null ? plural : "";
            this.shortName = shortName != null ? shortName : "";
            this.version = version != null ? version : "";
            this.scope = scope != null ? scope : io.dekorate.crd.confg.Scope.Namespaced;
    }

    public String getGroup(){
            return this.group;
    }

    public String getKind(){
            return this.kind;
    }

    public String getName(){
            return this.name;
    }

    public String getPlural(){
            return this.plural;
    }

    public String getShortName(){
            return this.shortName;
    }

    public String getVersion(){
            return this.version;
    }

    public Scope getScope(){
            return this.scope;
    }




}
