package io.dekorate.crd.adapter;

import java.nio.file.Path;
import io.dekorate.crd.annotation.CustomResource;
import io.dekorate.crd.config.CustomResourceConfigBuilder;
import java.lang.String;
import java.util.Comparator;
import io.dekorate.crd.config.CustomResourceConfig;
import io.dekorate.project.Project;
import io.dekorate.crd.confg.Scope;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.ScmInfo;
import java.util.Map;

public class CustomResourceConfigAdapter{



    public static CustomResourceConfig adapt(CustomResource instance){
            return newBuilder(instance).build();
    }

    public static CustomResourceConfigBuilder newBuilder(CustomResource instance){
            return new CustomResourceConfigBuilder(new io.dekorate.crd.config.CustomResourceConfig(null,
            null,
            instance.group(),
            instance.kind(),
            instance.name(),
            instance.plural(),
            instance.shortName(),
            instance.version(),
            instance.scope()));
    }

    public static CustomResourceConfig adapt(Map map){
            return new io.dekorate.crd.config.CustomResourceConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("kind", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("plural", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("shortName", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               Scope.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("scope","Namespaced") : "Namespaced")));
    }

    public static CustomResourceConfigBuilder newBuilder(Map map){
            return new CustomResourceConfigBuilder(new io.dekorate.crd.config.CustomResourceConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("kind", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("plural", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("shortName", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               Scope.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("scope","Namespaced") : "Namespaced"))));
    }




}
