/*
 * Decompiled with CFR 0.152.
 */
package defaultj.annotations.processor;

import defaultj.annotations.PostConstruct;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class PostConstructoAnnotationValidator
extends AbstractProcessor {
    private static final String POST_CONSTRCT = PostConstruct.class.getSimpleName();
    private Messager messager;
    private boolean hasError;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(PostConstruct.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element e, String msg) {
        this.hasError = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.hasError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(PostConstruct.class)) {
            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                if (0 == ((ExecutableElement)element).getParameters().size()) continue;
                this.error(element, String.format("Only methods with no parameter can be annotated with @%s!", POST_CONSTRCT));
                continue;
            }
            this.error(element, String.format("Only methods can be annotated with @%s!", POST_CONSTRCT));
        }
        return this.hasError;
    }
}

