/*
 * Decompiled with CFR 0.152.
 */
package defaultj.annotations.processor;

import defaultj.annotations.ImplementedBy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class ImplementedByAnnotationValidator
extends AbstractProcessor {
    private ProcessingEnvironment processingEnv;
    private Messager messager;
    private boolean hasError;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.processingEnv = processingEnv;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(ImplementedBy.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element e, String msg) {
        this.hasError = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.hasError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(ImplementedBy.class)) {
            TypeElement implementingType;
            List<String> allCompatibleTypes;
            ImplementedBy implementedBy;
            String implementingTypeName;
            String elementType = element.toString();
            if (elementType.equals(implementingTypeName = (implementedBy = element.getAnnotation(ImplementedBy.class)).toString().replaceAll("^.*\\(value = (.*)\\.class\\)$", "$1"))) {
                this.error(element, String.format("%s is not a valid implementation of itself.", elementType));
            }
            if ((allCompatibleTypes = this.getAllCompatibleTypes(implementingType = this.processingEnv.getElementUtils().getTypeElement(implementingTypeName))).contains(elementType)) continue;
            this.error(element, String.format("%s is not compatible with %s", implementingTypeName, elementType));
        }
        return this.hasError;
    }

    private List<String> getAllCompatibleTypes(TypeElement implementingType) {
        ArrayList<String> allCompatibleTypes = new ArrayList<String>();
        allCompatibleTypes.add(implementingType.getSuperclass().toString());
        allCompatibleTypes.addAll(implementingType.getInterfaces().stream().map(String::valueOf).collect(Collectors.toList()));
        return allCompatibleTypes;
    }
}

