/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.authentication.psk;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.AuthenticationException;
import io.deephaven.auth.AuthenticationRequestHandler;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class PskAuthenticationHandler
implements AuthenticationRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(PskAuthenticationHandler.class);
    private static final String PSK;

    public String getAuthType() {
        return this.getClass().getName();
    }

    public Optional<AuthContext> login(long protocolVersion, ByteBuffer payload, AuthenticationRequestHandler.HandshakeResponseListener listener) throws AuthenticationException {
        if (payload.remaining() == PSK.length() && StandardCharsets.US_ASCII.decode(payload).toString().equals(PSK)) {
            return Optional.of(new AuthContext.SuperUser());
        }
        return Optional.empty();
    }

    public Optional<AuthContext> login(String payload, AuthenticationRequestHandler.MetadataResponseListener listener) throws AuthenticationException {
        if (payload.equals(PSK)) {
            return Optional.of(new AuthContext.SuperUser());
        }
        return Optional.empty();
    }

    public void initialize(String targetUrl) {
        logger.warn().nl().nl().nl().nl().endl();
        logger.warn().append((CharSequence)"================================================================================").endl();
        logger.warn().append((CharSequence)"Superuser access through pre-shared key is enabled - use ").append((CharSequence)PSK).append((CharSequence)" to connect").endl();
        logger.warn().append((CharSequence)"Connect automatically to Web UI with ").append((CharSequence)targetUrl).append((CharSequence)"/?psk=").append((CharSequence)PSK).endl();
        logger.warn().append((CharSequence)"================================================================================").endl();
        logger.warn().nl().nl().nl().nl().endl();
    }

    public List<String> urls(String targetUrl) {
        return List.of(targetUrl + "/?psk=" + PSK);
    }

    static {
        String pskFromConfig = Configuration.getInstance().getStringWithDefault("authentication.psk", null);
        PSK = Optional.ofNullable(pskFromConfig).map(String::trim).filter(s -> !s.isEmpty()).orElseGet(() -> Long.toString(Math.abs(new Random().nextLong()), 36));
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(PSK)) {
            throw new IllegalArgumentException("Provided pre-shared key isn't valid ASCII, cannot be used: " + PSK);
        }
    }
}

