/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.generic.region;

import io.deephaven.base.MathUtil;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.PageStore;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionShort;
import io.deephaven.engine.table.impl.sources.regioned.GenericColumnRegionBase;
import io.deephaven.generic.page.ChunkHolderPageShort;
import io.deephaven.generic.region.AppendOnlyRegionAccessor;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendOnlyFixedSizePageRegionShort<ATTR extends Any>
extends GenericColumnRegionBase<ATTR>
implements PageStore<ATTR, ATTR, ChunkHolderPageShort<ATTR>>,
ColumnRegionShort<ATTR> {
    private final int pageSize;
    private final AppendOnlyRegionAccessor<ATTR> accessor;
    private volatile SoftReference<ChunkHolderPageShort<ATTR>>[] pageHolderRefs = new SoftReference[0];

    public AppendOnlyFixedSizePageRegionShort(long pageMask, int pageSize, @NotNull AppendOnlyRegionAccessor<ATTR> accessor) {
        super(pageMask);
        this.pageSize = pageSize;
        this.accessor = accessor;
    }

    public short getShort(long rowKey) {
        ChunkHolderPageShort<ATTR> page = this.getPageContaining(rowKey);
        try {
            return page.get(rowKey);
        }
        catch (Exception e) {
            throw new TableDataException(String.format("Error retrieving short at row key %s", rowKey), (Throwable)e);
        }
    }

    @NotNull
    public final ChunkHolderPageShort<ATTR> getPageContaining(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        return this.getPageContaining(rowKey);
    }

    @NotNull
    private ChunkHolderPageShort<ATTR> getPageContaining(long rowKey) {
        this.throwIfInvalidated();
        long firstRowPosition = rowKey & this.mask();
        int pageIndex = Math.toIntExact(firstRowPosition / (long)this.pageSize);
        if (pageIndex >= 0x7FFFFFF7) {
            throw new UnsupportedOperationException(String.format("Cannot support more than %s pages, increase page size from %s", 0x7FFFFFF7, this.pageSize));
        }
        long pageFirstRowInclusive = (long)pageIndex * (long)this.pageSize;
        ChunkHolderPageShort<ATTR> pageHolder = this.ensurePage(pageIndex, pageFirstRowInclusive);
        this.ensureFilled(pageHolder, pageIndex, pageFirstRowInclusive);
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkHolderPageShort<ATTR> ensurePage(int pageIndex, long pageFirstRowInclusive) {
        ChunkHolderPageShort<ATTR> pageHolder;
        SoftReference<ChunkHolderPageShort<ATTR>> pageHolderRef;
        SoftReference<ChunkHolderPageShort<ATTR>>[] localPageHolderRefs = this.pageHolderRefs;
        if (this.pageHolderRefs.length <= pageIndex || (pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
            AppendOnlyFixedSizePageRegionShort appendOnlyFixedSizePageRegionShort = this;
            synchronized (appendOnlyFixedSizePageRegionShort) {
                localPageHolderRefs = this.pageHolderRefs;
                if (this.pageHolderRefs.length <= pageIndex) {
                    int numPages = Math.min(1 << MathUtil.ceilLog2((int)(pageIndex + 1)), 0x7FFFFFF7);
                    this.pageHolderRefs = localPageHolderRefs = Arrays.copyOf(localPageHolderRefs, numPages);
                }
                if ((pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
                    pageHolder = new ChunkHolderPageShort(this.mask(), pageFirstRowInclusive, new short[this.pageSize]);
                    this.pageHolderRefs[pageIndex] = new SoftReference<ChunkHolderPageShort<ATTR>>(pageHolder);
                }
            }
        }
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFilled(@NotNull ChunkHolderPageShort<ATTR> pageHolder, int pageIndex, long pageFirstRowInclusive) {
        if (pageHolder.size() >= this.pageSize) {
            return;
        }
        long regionSize = this.accessor.size();
        long pageLastRowExclusive = Math.min(regionSize, ((long)pageIndex + 1L) * (long)this.pageSize);
        int thisPageSize = Math.toIntExact(pageLastRowExclusive - pageFirstRowInclusive);
        if (pageHolder.size() >= thisPageSize) {
            return;
        }
        ChunkHolderPageShort<ATTR> chunkHolderPageShort = pageHolder;
        synchronized (chunkHolderPageShort) {
            int currentSize = pageHolder.size();
            if (currentSize >= thisPageSize) {
                return;
            }
            WritableShortChunk<ATTR> destination = pageHolder.getSliceForAppend(currentSize);
            this.accessor.readChunkPage(pageFirstRowInclusive + (long)currentSize, thisPageSize - currentSize, (WritableChunk<ATTR>)destination);
            pageHolder.acceptAppend((ShortChunk<ATTR>)destination, currentSize);
        }
    }
}

