/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.generic.region;

import io.deephaven.base.MathUtil;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.PageStore;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionLong;
import io.deephaven.engine.table.impl.sources.regioned.GenericColumnRegionBase;
import io.deephaven.generic.page.ChunkHolderPageLong;
import io.deephaven.generic.region.AppendOnlyRegionAccessor;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendOnlyFixedSizePageRegionLong<ATTR extends Any>
extends GenericColumnRegionBase<ATTR>
implements PageStore<ATTR, ATTR, ChunkHolderPageLong<ATTR>>,
ColumnRegionLong<ATTR> {
    private final int pageSize;
    private final AppendOnlyRegionAccessor<ATTR> accessor;
    private volatile SoftReference<ChunkHolderPageLong<ATTR>>[] pageHolderRefs = new SoftReference[0];

    public AppendOnlyFixedSizePageRegionLong(long pageMask, int pageSize, @NotNull AppendOnlyRegionAccessor<ATTR> accessor) {
        super(pageMask);
        this.pageSize = pageSize;
        this.accessor = accessor;
    }

    public long getLong(long rowKey) {
        ChunkHolderPageLong<ATTR> page = this.getPageContaining(rowKey);
        try {
            return page.get(rowKey);
        }
        catch (Exception e) {
            throw new TableDataException(String.format("Error retrieving long at row key %s", rowKey), (Throwable)e);
        }
    }

    @NotNull
    public final ChunkHolderPageLong<ATTR> getPageContaining(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        return this.getPageContaining(rowKey);
    }

    @NotNull
    private ChunkHolderPageLong<ATTR> getPageContaining(long rowKey) {
        this.throwIfInvalidated();
        long firstRowPosition = rowKey & this.mask();
        int pageIndex = Math.toIntExact(firstRowPosition / (long)this.pageSize);
        if (pageIndex >= 0x7FFFFFF7) {
            throw new UnsupportedOperationException(String.format("Cannot support more than %s pages, increase page size from %s", 0x7FFFFFF7, this.pageSize));
        }
        long pageFirstRowInclusive = (long)pageIndex * (long)this.pageSize;
        ChunkHolderPageLong<ATTR> pageHolder = this.ensurePage(pageIndex, pageFirstRowInclusive);
        this.ensureFilled(pageHolder, pageIndex, pageFirstRowInclusive);
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkHolderPageLong<ATTR> ensurePage(int pageIndex, long pageFirstRowInclusive) {
        ChunkHolderPageLong<ATTR> pageHolder;
        SoftReference<ChunkHolderPageLong<ATTR>> pageHolderRef;
        SoftReference<ChunkHolderPageLong<ATTR>>[] localPageHolderRefs = this.pageHolderRefs;
        if (this.pageHolderRefs.length <= pageIndex || (pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
            AppendOnlyFixedSizePageRegionLong appendOnlyFixedSizePageRegionLong = this;
            synchronized (appendOnlyFixedSizePageRegionLong) {
                localPageHolderRefs = this.pageHolderRefs;
                if (this.pageHolderRefs.length <= pageIndex) {
                    int numPages = Math.min(1 << MathUtil.ceilLog2((int)(pageIndex + 1)), 0x7FFFFFF7);
                    this.pageHolderRefs = localPageHolderRefs = Arrays.copyOf(localPageHolderRefs, numPages);
                }
                if ((pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
                    pageHolder = new ChunkHolderPageLong(this.mask(), pageFirstRowInclusive, new long[this.pageSize]);
                    this.pageHolderRefs[pageIndex] = new SoftReference<ChunkHolderPageLong<ATTR>>(pageHolder);
                }
            }
        }
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFilled(@NotNull ChunkHolderPageLong<ATTR> pageHolder, int pageIndex, long pageFirstRowInclusive) {
        if (pageHolder.size() >= this.pageSize) {
            return;
        }
        long regionSize = this.accessor.size();
        long pageLastRowExclusive = Math.min(regionSize, ((long)pageIndex + 1L) * (long)this.pageSize);
        int thisPageSize = Math.toIntExact(pageLastRowExclusive - pageFirstRowInclusive);
        if (pageHolder.size() >= thisPageSize) {
            return;
        }
        ChunkHolderPageLong<ATTR> chunkHolderPageLong = pageHolder;
        synchronized (chunkHolderPageLong) {
            int currentSize = pageHolder.size();
            if (currentSize >= thisPageSize) {
                return;
            }
            WritableLongChunk<ATTR> destination = pageHolder.getSliceForAppend(currentSize);
            this.accessor.readChunkPage(pageFirstRowInclusive + (long)currentSize, thisPageSize - currentSize, (WritableChunk<ATTR>)destination);
            pageHolder.acceptAppend((LongChunk<ATTR>)destination, currentSize);
        }
    }
}

