/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.generic.region;

import io.deephaven.base.MathUtil;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.PageStore;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionChar;
import io.deephaven.engine.table.impl.sources.regioned.GenericColumnRegionBase;
import io.deephaven.generic.page.ChunkHolderPageChar;
import io.deephaven.generic.region.AppendOnlyRegionAccessor;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendOnlyFixedSizePageRegionChar<ATTR extends Any>
extends GenericColumnRegionBase<ATTR>
implements PageStore<ATTR, ATTR, ChunkHolderPageChar<ATTR>>,
ColumnRegionChar<ATTR> {
    private final int pageSize;
    private final AppendOnlyRegionAccessor<ATTR> accessor;
    private volatile SoftReference<ChunkHolderPageChar<ATTR>>[] pageHolderRefs = new SoftReference[0];

    public AppendOnlyFixedSizePageRegionChar(long pageMask, int pageSize, @NotNull AppendOnlyRegionAccessor<ATTR> accessor) {
        super(pageMask);
        this.pageSize = pageSize;
        this.accessor = accessor;
    }

    public char getChar(long rowKey) {
        ChunkHolderPageChar<ATTR> page = this.getPageContaining(rowKey);
        try {
            return page.get(rowKey);
        }
        catch (Exception e) {
            throw new TableDataException(String.format("Error retrieving char at row key %s", rowKey), (Throwable)e);
        }
    }

    @NotNull
    public final ChunkHolderPageChar<ATTR> getPageContaining(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        return this.getPageContaining(rowKey);
    }

    @NotNull
    private ChunkHolderPageChar<ATTR> getPageContaining(long rowKey) {
        this.throwIfInvalidated();
        long firstRowPosition = rowKey & this.mask();
        int pageIndex = Math.toIntExact(firstRowPosition / (long)this.pageSize);
        if (pageIndex >= 0x7FFFFFF7) {
            throw new UnsupportedOperationException(String.format("Cannot support more than %s pages, increase page size from %s", 0x7FFFFFF7, this.pageSize));
        }
        long pageFirstRowInclusive = (long)pageIndex * (long)this.pageSize;
        ChunkHolderPageChar<ATTR> pageHolder = this.ensurePage(pageIndex, pageFirstRowInclusive);
        this.ensureFilled(pageHolder, pageIndex, pageFirstRowInclusive);
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkHolderPageChar<ATTR> ensurePage(int pageIndex, long pageFirstRowInclusive) {
        ChunkHolderPageChar<ATTR> pageHolder;
        SoftReference<ChunkHolderPageChar<ATTR>> pageHolderRef;
        SoftReference<ChunkHolderPageChar<ATTR>>[] localPageHolderRefs = this.pageHolderRefs;
        if (this.pageHolderRefs.length <= pageIndex || (pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
            AppendOnlyFixedSizePageRegionChar appendOnlyFixedSizePageRegionChar = this;
            synchronized (appendOnlyFixedSizePageRegionChar) {
                localPageHolderRefs = this.pageHolderRefs;
                if (this.pageHolderRefs.length <= pageIndex) {
                    int numPages = Math.min(1 << MathUtil.ceilLog2((int)(pageIndex + 1)), 0x7FFFFFF7);
                    this.pageHolderRefs = localPageHolderRefs = Arrays.copyOf(localPageHolderRefs, numPages);
                }
                if ((pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
                    pageHolder = new ChunkHolderPageChar(this.mask(), pageFirstRowInclusive, new char[this.pageSize]);
                    this.pageHolderRefs[pageIndex] = new SoftReference<ChunkHolderPageChar<ATTR>>(pageHolder);
                }
            }
        }
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFilled(@NotNull ChunkHolderPageChar<ATTR> pageHolder, int pageIndex, long pageFirstRowInclusive) {
        if (pageHolder.size() >= this.pageSize) {
            return;
        }
        long regionSize = this.accessor.size();
        long pageLastRowExclusive = Math.min(regionSize, ((long)pageIndex + 1L) * (long)this.pageSize);
        int thisPageSize = Math.toIntExact(pageLastRowExclusive - pageFirstRowInclusive);
        if (pageHolder.size() >= thisPageSize) {
            return;
        }
        ChunkHolderPageChar<ATTR> chunkHolderPageChar = pageHolder;
        synchronized (chunkHolderPageChar) {
            int currentSize = pageHolder.size();
            if (currentSize >= thisPageSize) {
                return;
            }
            WritableCharChunk<ATTR> destination = pageHolder.getSliceForAppend(currentSize);
            this.accessor.readChunkPage(pageFirstRowInclusive + (long)currentSize, thisPageSize - currentSize, (WritableChunk<ATTR>)destination);
            pageHolder.acceptAppend((CharChunk<ATTR>)destination, currentSize);
        }
    }
}

