/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.generic.region;

import io.deephaven.base.MathUtil;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.PageStore;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionByte;
import io.deephaven.engine.table.impl.sources.regioned.GenericColumnRegionBase;
import io.deephaven.generic.page.ChunkHolderPageByte;
import io.deephaven.generic.region.AppendOnlyRegionAccessor;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendOnlyFixedSizePageRegionByte<ATTR extends Any>
extends GenericColumnRegionBase<ATTR>
implements PageStore<ATTR, ATTR, ChunkHolderPageByte<ATTR>>,
ColumnRegionByte<ATTR> {
    private final int pageSize;
    private final AppendOnlyRegionAccessor<ATTR> accessor;
    private volatile SoftReference<ChunkHolderPageByte<ATTR>>[] pageHolderRefs = new SoftReference[0];

    public AppendOnlyFixedSizePageRegionByte(long pageMask, int pageSize, @NotNull AppendOnlyRegionAccessor<ATTR> accessor) {
        super(pageMask);
        this.pageSize = pageSize;
        this.accessor = accessor;
    }

    public byte getByte(long rowKey) {
        ChunkHolderPageByte<ATTR> page = this.getPageContaining(rowKey);
        try {
            return page.get(rowKey);
        }
        catch (Exception e) {
            throw new TableDataException(String.format("Error retrieving byte at row key %s", rowKey), (Throwable)e);
        }
    }

    public byte[] getBytes(long firstRowKey, @NotNull byte[] destination, int destinationOffset, int length) {
        WritableByteChunk byteChunk = WritableByteChunk.writableChunkWrap((byte[])destination, (int)destinationOffset, (int)length);
        try (RowSequence rowSequence = RowSequenceFactory.forRange((long)firstRowKey, (long)(firstRowKey + (long)length - 1L));){
            this.fillChunk(DEFAULT_FILL_INSTANCE, (WritableChunk)byteChunk, rowSequence);
        }
        return destination;
    }

    @NotNull
    public final ChunkHolderPageByte<ATTR> getPageContaining(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        return this.getPageContaining(rowKey);
    }

    @NotNull
    private ChunkHolderPageByte<ATTR> getPageContaining(long rowKey) {
        this.throwIfInvalidated();
        long firstRowPosition = rowKey & this.mask();
        int pageIndex = Math.toIntExact(firstRowPosition / (long)this.pageSize);
        if (pageIndex >= 0x7FFFFFF7) {
            throw new UnsupportedOperationException(String.format("Cannot support more than %s pages, increase page size from %s", 0x7FFFFFF7, this.pageSize));
        }
        long pageFirstRowInclusive = (long)pageIndex * (long)this.pageSize;
        ChunkHolderPageByte<ATTR> pageHolder = this.ensurePage(pageIndex, pageFirstRowInclusive);
        this.ensureFilled(pageHolder, pageIndex, pageFirstRowInclusive);
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkHolderPageByte<ATTR> ensurePage(int pageIndex, long pageFirstRowInclusive) {
        ChunkHolderPageByte<ATTR> pageHolder;
        SoftReference<ChunkHolderPageByte<ATTR>> pageHolderRef;
        SoftReference<ChunkHolderPageByte<ATTR>>[] localPageHolderRefs = this.pageHolderRefs;
        if (this.pageHolderRefs.length <= pageIndex || (pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
            AppendOnlyFixedSizePageRegionByte appendOnlyFixedSizePageRegionByte = this;
            synchronized (appendOnlyFixedSizePageRegionByte) {
                localPageHolderRefs = this.pageHolderRefs;
                if (this.pageHolderRefs.length <= pageIndex) {
                    int numPages = Math.min(1 << MathUtil.ceilLog2((int)(pageIndex + 1)), 0x7FFFFFF7);
                    this.pageHolderRefs = localPageHolderRefs = Arrays.copyOf(localPageHolderRefs, numPages);
                }
                if ((pageHolderRef = localPageHolderRefs[pageIndex]) == null || (pageHolder = pageHolderRef.get()) == null) {
                    pageHolder = new ChunkHolderPageByte(this.mask(), pageFirstRowInclusive, new byte[this.pageSize]);
                    this.pageHolderRefs[pageIndex] = new SoftReference<ChunkHolderPageByte<ATTR>>(pageHolder);
                }
            }
        }
        return pageHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFilled(@NotNull ChunkHolderPageByte<ATTR> pageHolder, int pageIndex, long pageFirstRowInclusive) {
        if (pageHolder.size() >= this.pageSize) {
            return;
        }
        long regionSize = this.accessor.size();
        long pageLastRowExclusive = Math.min(regionSize, ((long)pageIndex + 1L) * (long)this.pageSize);
        int thisPageSize = Math.toIntExact(pageLastRowExclusive - pageFirstRowInclusive);
        if (pageHolder.size() >= thisPageSize) {
            return;
        }
        ChunkHolderPageByte<ATTR> chunkHolderPageByte = pageHolder;
        synchronized (chunkHolderPageByte) {
            int currentSize = pageHolder.size();
            if (currentSize >= thisPageSize) {
                return;
            }
            WritableByteChunk<ATTR> destination = pageHolder.getSliceForAppend(currentSize);
            this.accessor.readChunkPage(pageFirstRowInclusive + (long)currentSize, thisPageSize - currentSize, (WritableChunk<ATTR>)destination);
            pageHolder.acceptAppend((ByteChunk<ATTR>)destination, currentSize);
        }
    }
}

