/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.generic.page;

import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.Page;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.impl.DefaultChunkSource;
import org.jetbrains.annotations.NotNull;

public class ChunkHolderPageDouble<ATTR extends Any>
implements Page.WithDefaults<ATTR>,
DefaultChunkSource.SupportsContiguousGet<ATTR> {
    private final long mask;
    private final long firstRow;
    private final double[] storage;
    private volatile DoubleChunk<ATTR> currentView;

    public ChunkHolderPageDouble(long mask, long firstRow, @NotNull double[] storage) {
        this.mask = mask;
        this.firstRow = Require.inRange((long)firstRow, (String)"firstRow", (long)mask, (String)"mask");
        this.storage = storage;
        this.currentView = DoubleChunk.getEmptyChunk();
    }

    public final ChunkType getChunkType() {
        return ChunkType.Double;
    }

    public final long firstRowOffset() {
        return this.firstRow;
    }

    public final long maxRow(long rowKey) {
        return rowKey & (this.mask() ^ 0xFFFFFFFFFFFFFFFFL) | this.firstRowOffset() + (long)this.storage.length - 1L;
    }

    private int getChunkOffset(long rowKey) {
        return (int)this.getRowOffset(rowKey);
    }

    public final long mask() {
        return this.mask;
    }

    public final int size() {
        return this.currentView.size();
    }

    public final double get(long rowKey) {
        return this.currentView.get(this.getChunkOffset(rowKey));
    }

    public final Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, long firstKey, long lastKey) {
        return this.currentView.slice(this.getChunkOffset(firstKey), Math.toIntExact(lastKey - firstKey + 1L));
    }

    public final void fillChunkAppend(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super ATTR> destination, @NotNull RowSequence rowSequence) {
        WritableDoubleChunk to = destination.asWritableDoubleChunk();
        DoubleChunk<ATTR> localView = this.currentView;
        if (rowSequence.getAverageRunLengthEstimate() >= 16L) {
            rowSequence.forAllRowKeyRanges((firstRowKey, lastRowKey) -> to.appendTypedChunk(localView, this.getChunkOffset(firstRowKey), (int)(lastRowKey - firstRowKey + 1L)));
        } else {
            rowSequence.forAllRowKeys(rowKey -> to.add(localView.get(this.getChunkOffset(rowKey))));
        }
    }

    public final WritableDoubleChunk<ATTR> getSliceForAppend(int expectedCurrentSize) {
        Assert.eq((int)expectedCurrentSize, (String)"expectedCurrentSize", (int)this.size(), (String)"current size");
        return WritableDoubleChunk.writableChunkWrap((double[])this.storage, (int)expectedCurrentSize, (int)(this.storage.length - expectedCurrentSize));
    }

    public final void acceptAppend(@NotNull DoubleChunk<ATTR> slice, int expectedCurrentSize) {
        Assert.eq((int)expectedCurrentSize, (String)"expectedCurrentSize", (int)this.size(), (String)"current size");
        Assert.assertion((boolean)slice.isAlias((Object)this.storage), (String)"slice.isAlias(storage)");
        this.currentView = DoubleChunk.chunkWrap((double[])this.storage, (int)0, (int)(expectedCurrentSize + slice.size()));
    }
}

