/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnectionForcedCcsid;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCDriverRegistration;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CcsidOverrideIT {
    private static final Logger log = Logger.getLogger(CcsidOverrideIT.class.toString());
    private static final int columnCcsid = 37;
    Charset columnCcsidCP = Charset.forName(String.format("CP%03d", 37));
    private static final String data = "\u00a3$[^~?\u00a2\u00af\u20ac123";
    private static final int wrongCcsid = 1146;
    Charset wrongCcsidCP = Charset.forName(String.format("CP%03d", 1146));
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    @Test
    public void ccsidOverrideTest() throws Exception {
        AS400JDBCDriverRegistration.registerCcsidDriver();
        Properties props = CcsidOverrideIT.configurePropertiesForDriver(37, 1146);
        String host = System.getenv("ISERIES_HOST");
        String schema = System.getenv("ISERIES_SCHEMA");
        try (Connection con = DriverManager.getConnection(String.format("jdbc:as400://%s/", host), props);){
            Assertions.assertEquals(AS400JDBCConnectionForcedCcsid.class, con.getClass());
            try (PreparedStatement ps = con.prepareStatement(String.format("select name from %s.ccsidTest where id = ?", schema));){
                ps.setInt(1, 1);
                try (ResultSet rs = ps.executeQuery();){
                    Assertions.assertTrue((boolean)rs.next(), (String)"found inserted data");
                    String retrieved = rs.getString(1).trim();
                    byte[] retrievedBytes = rs.getBytes(1);
                    byte[] expectedBytes = data.getBytes(this.wrongCcsidCP);
                    log.log(Level.FINE, "sent     {0}", data);
                    log.log(Level.FINE, "received {0}", retrieved);
                    log.log(Level.FINE, "expected ebdic  {0}", CcsidOverrideIT.bytesToHex(expectedBytes));
                    log.log(Level.FINE, "recieved ebdic  {0}", CcsidOverrideIT.bytesToHex(retrievedBytes));
                    Assertions.assertEquals((Object)data, (Object)retrieved);
                    Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])retrievedBytes);
                }
            }
        }
    }

    @Test
    public void ccsidOriginalTest() throws Exception {
        AS400JDBCDriverRegistration.registerOriginalDriver();
        Properties props = CcsidOverrideIT.configurePropertiesForDriver(37, 1146);
        String host = System.getenv("ISERIES_HOST");
        String schema = System.getenv("ISERIES_SCHEMA");
        try (Connection con = DriverManager.getConnection(String.format("jdbc:as400://%s/", host), props);){
            Assertions.assertEquals(AS400JDBCConnectionImpl.class, con.getClass());
            try (PreparedStatement ps = con.prepareStatement(String.format("select name from %s.ccsidTest where id = ?", schema));){
                ps.setInt(1, 1);
                try (ResultSet rs = ps.executeQuery();){
                    Assertions.assertTrue((boolean)rs.next(), (String)"found inserted data");
                    String retrieved = rs.getString(1).trim();
                    byte[] retrievedBytes = rs.getBytes(1);
                    byte[] expectedBytes = data.getBytes(this.wrongCcsidCP);
                    String expectedString = new String(expectedBytes, this.columnCcsidCP);
                    log.log(Level.FINE, "sent     {0}", data);
                    log.log(Level.FINE, "received {0}", retrieved);
                    log.log(Level.FINE, "expected {0}", expectedString);
                    log.log(Level.FINE, "expected ebdic  {0}", CcsidOverrideIT.bytesToHex(expectedBytes));
                    log.log(Level.FINE, "recieved ebdic  {0}", CcsidOverrideIT.bytesToHex(retrievedBytes));
                    Assertions.assertEquals((Object)expectedString, (Object)retrieved);
                    Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])retrievedBytes);
                }
            }
        }
    }

    private static void insertData(Connection con, String schema) throws SQLException {
        log.info(con.getClass().toString());
        try (PreparedStatement ps = con.prepareStatement(String.format("insert into %s.ccsidTest (id, name) values (?, ?)", schema));){
            ps.setInt(1, 1);
            ps.setString(2, data);
            int updated = ps.executeUpdate();
            Assertions.assertEquals((int)1, (int)updated, (String)"inserted one row");
        }
        con.commit();
    }

    private static Properties configurePropertiesForDriver(int fromCcsid, int toCcsid) {
        String user = System.getenv("ISERIES_USER");
        String password = System.getenv("ISERIES_PASSWORD");
        String schema = System.getenv("ISERIES_SCHEMA");
        Properties props = new Properties();
        props.setProperty("from_ccsid", Integer.toString(fromCcsid));
        props.setProperty("to_ccsid", Integer.toString(toCcsid));
        props.setProperty("user", user);
        props.setProperty("password", password);
        props.setProperty("errors", "full");
        props.setProperty("prompt", "false");
        props.setProperty("libraries", schema);
        props.setProperty("naming", "system");
        return props;
    }

    @BeforeAll
    public static void outputUtf8OnWindows() throws UnsupportedEncodingException {
        System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, "UTF-8"));
    }

    @BeforeAll
    public static void setupTable() throws SQLException {
        AS400JDBCDriverRegistration.registerCcsidDriver();
        Properties props = CcsidOverrideIT.configurePropertiesForDriver(37, 1146);
        String host = System.getenv("ISERIES_HOST");
        String schema = System.getenv("ISERIES_SCHEMA");
        try (Connection con = DriverManager.getConnection(String.format("jdbc:as400://%s/", host), props);){
            CcsidOverrideIT.dropTable(con, host, schema);
            CcsidOverrideIT.createTable(con, host, schema);
            CcsidOverrideIT.insertData(con, schema);
        }
    }

    @AfterAll
    public static void cleanUp() throws SQLException {
        AS400JDBCDriverRegistration.registerCcsidDriver();
        Properties props = CcsidOverrideIT.configurePropertiesForDriver(37, 1146);
        String host = System.getenv("ISERIES_HOST");
        String schema = System.getenv("ISERIES_SCHEMA");
        try (Connection con = DriverManager.getConnection(String.format("jdbc:as400://%s/", host), props);){
            CcsidOverrideIT.dropTable(con, host, schema);
        }
    }

    private static void createTable(Connection con, String host, String schema) throws SQLException {
        try (PreparedStatement ps = con.prepareStatement(String.format("create table %s.ccsidTest (id int, name varchar(200) CCSID %d)", schema, 37));){
            ps.execute();
        }
    }

    private static void dropTable(Connection con, String host, String schema) {
        try (PreparedStatement ps = con.prepareStatement(String.format("drop table %s.ccsidTest", schema));){
            ps.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }
}

