/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCDriverRegistration;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class AS400JDBCDriverForcedCcsid
implements Driver {
    static final int MAJOR_VERSION_ = 13;
    static final int MINOR_VERSION_ = 2;
    static final String DATABASE_PRODUCT_NAME_ = "DB2 UDB for AS/400";
    static final String DRIVER_NAME_ = "AS/400 Toolbox for Java JDBC Driver";
    static final String DRIVER_LEVEL_ = "07050002";
    public static final int JDBC_MAJOR_VERSION_ = 4;
    public static final int JDBC_MINOR_VERSION_ = 3;
    private static final String MRI_NOT_FOUND_ = "9999:9999";
    private static ResourceBundle resources_;
    private static ResourceBundle resources2_;
    private static final String CLASSNAME = "com.ibm.as400.access.AS400JDBCDriverForcedCcsid";
    private static Driver nativeDriver;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        return dataSourceUrl.isValid();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        Properties urlProperties = dataSourceUrl.getProperties();
        if (JDProperties.isTraceSet((Properties)urlProperties, (Properties)info) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn((boolean)true);
            }
        } else if (JDProperties.isTraceSet((Properties)urlProperties, (Properties)info) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn((boolean)false);
        }
        if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceDatastreamOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceDiagnosticOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceErrorOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceInformationOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceWarningOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceConversionOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceProxyOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTracePCMLOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceJDBCOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceAllOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceThreadOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet((Properties)urlProperties, (Properties)info) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn((boolean)false);
        }
        if (JDTrace.isTraceOn()) {
            Object traceUrl = url;
            int passwordIndex = url.indexOf("password=");
            if (passwordIndex >= 0) {
                int semicolonIndex = url.indexOf(";", passwordIndex);
                traceUrl = semicolonIndex < 0 ? url.substring(0, passwordIndex) + "password=******" : url.substring(0, passwordIndex) + "password=******" + url.substring(semicolonIndex);
            }
            JDTrace.logInformation((Object)this, (String)("connect called with URL: " + (String)traceUrl));
        }
        JDProperties jdProperties = new JDProperties(urlProperties, info);
        Connection connection = null;
        if (dataSourceUrl.isValid()) {
            connection = this.initializeConnection(dataSourceUrl, jdProperties, info);
        }
        return connection;
    }

    public Connection connect(AS400 system) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (system instanceof SecureAS400) {
            return this.initializeConnection((AS400)new SecureAS400(system));
        }
        return this.initializeConnection(new AS400(system));
    }

    public Connection connect(AS400 system, boolean clone) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (!clone) {
            return this.initializeConnection(system);
        }
        return this.connect(system);
    }

    public Connection connect(AS400 system, Properties info, String schema, boolean clone) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (info == null) {
            throw new NullPointerException("properties");
        }
        if (JDProperties.isTraceSet(null, (Properties)info) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn((boolean)true);
            }
        } else if (JDProperties.isTraceSet(null, (Properties)info) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn((boolean)false);
        }
        if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceDatastreamOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceDiagnosticOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceErrorOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceInformationOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceWarningOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceConversionOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceProxyOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTracePCMLOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceJDBCOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceAllOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceThreadOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn((boolean)false);
        }
        if (!clone) {
            return this.initializeConnection(schema, info, system);
        }
        if (system instanceof SecureAS400) {
            return this.initializeConnection(schema, info, (AS400)new SecureAS400(system));
        }
        return this.initializeConnection(schema, info, new AS400(system));
    }

    public Connection connect(AS400 system, Properties info, String schema) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (info == null) {
            throw new NullPointerException("properties");
        }
        if (JDProperties.isTraceSet(null, (Properties)info) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn((boolean)true);
            }
        } else if (JDProperties.isTraceSet(null, (Properties)info) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn((boolean)false);
        }
        if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceDatastreamOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceDiagnosticOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceErrorOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceInformationOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceWarningOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceConversionOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceProxyOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTracePCMLOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceJDBCOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceAllOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn((boolean)true);
            }
            Trace.setTraceThreadOn((boolean)true);
        } else if (JDProperties.isToolboxTraceSet(null, (Properties)info) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn((boolean)false);
        }
        if (system instanceof SecureAS400) {
            return this.initializeConnection(schema, info, (AS400)new SecureAS400(system));
        }
        return this.initializeConnection(schema, info, new AS400(system));
    }

    @Override
    public int getMajorVersion() {
        return 13;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        DriverPropertyInfo[] dpi = null;
        if (dataSourceUrl.isValid()) {
            JDProperties properties = new JDProperties(dataSourceUrl.getProperties(), info);
            dpi = properties.getInfo();
        }
        return dpi;
    }

    static String getResource(String key, String[] replacementVariables) {
        String resource;
        if (resources_ == null) {
            resource = MRI_NOT_FOUND_;
        } else {
            try {
                resource = resources_.getString(key);
            }
            catch (MissingResourceException e) {
                if (resources2_ == null) {
                    resource = MRI_NOT_FOUND_;
                }
                try {
                    resource = resources2_.getString(key);
                }
                catch (MissingResourceException e1) {
                    JDTrace.logInformation(AS400JDBCDriver.class, (String)("Missing resource [" + key + "]"));
                    resource = MRI_NOT_FOUND_;
                }
            }
        }
        if (replacementVariables != null) {
            resource = AS400JDBCDriverForcedCcsid.substitute(resource, replacementVariables);
        }
        return resource;
    }

    static String substitute(String text, Object[] values) {
        String result = text;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                String variable = "&" + i;
                int j = result.indexOf(variable);
                if (j < 0) continue;
                StringBuffer buffer = new StringBuffer();
                buffer.append(result.substring(0, j));
                buffer.append(values[i].toString());
                buffer.append(result.substring(j + variable.length()));
                result = buffer.toString();
            }
        }
        return result;
    }

    static AS400 initializeAS400(JDDataSourceURL dataSourceUrl, JDProperties jdProperties, Properties info) throws SQLException {
        String serverName = dataSourceUrl.getServerName();
        String userName = jdProperties.getString(29);
        String password = jdProperties.getString(16);
        String prompt = jdProperties.getString(18);
        boolean secure = jdProperties.getBoolean(32);
        boolean useThreads = jdProperties.getBoolean(38);
        String secureCurrentUser = SystemProperties.getProperty((String)"com.ibm.as400.access.JDBC.secureCurrentUser");
        boolean isSecureCurrentUser = true;
        if (secureCurrentUser != null && !Boolean.valueOf(secureCurrentUser).booleanValue() || !jdProperties.getBoolean(78)) {
            isSecureCurrentUser = false;
        }
        if (info == null) {
            info = new Properties();
        }
        String userParm = info.getProperty("user");
        String passwordParm = info.getProperty("password");
        boolean forcePrompt = false;
        if ("".equals(userName) && "".equals(userParm) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriverForcedCcsid.class, (String)"Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if ("".equals(password) && "".equals(passwordParm) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriverForcedCcsid.class, (String)"Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (userParm != null) {
            if (userParm.compareToIgnoreCase("*CURRENT") == 0 && isSecureCurrentUser) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(AS400JDBCDriverForcedCcsid.class, (String)"Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
                }
                forcePrompt = true;
            }
        } else if (!"".equals(userName) && (userName.equals("") || userName.compareToIgnoreCase("*CURRENT") == 0) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriverForcedCcsid.class, (String)"Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (passwordParm != null) {
            if (passwordParm.compareToIgnoreCase("*CURRENT") == 0 && isSecureCurrentUser) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(AS400JDBCDriverForcedCcsid.class, (String)"Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
                }
                forcePrompt = true;
            }
        } else if (!"".equals(password) && (password.equals("") || password.compareToIgnoreCase("*CURRENT") == 0) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriverForcedCcsid.class, (String)"Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        Object as400 = null;
        as400 = secure ? (serverName.length() == 0 ? new SecureAS400() : (userName.length() == 0 ? new SecureAS400(serverName) : (password.length() == 0 ? new SecureAS400(serverName, userName) : new SecureAS400(serverName, userName, password)))) : (serverName.length() == 0 ? new AS400() : (userName.length() == 0 ? new AS400(serverName) : (password.length() == 0 ? new AS400(serverName, userName) : new AS400(serverName, userName, password))));
        try {
            if (!prompt.equals("")) {
                as400.setGuiAvailable(jdProperties.getBoolean(18));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!useThreads) {
                as400.setThreadUsed(useThreads);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (forcePrompt) {
            as400.forcePrompt();
        }
        return as400;
    }

    private Connection initializeConnection(JDDataSourceURL dataSourceUrl, JDProperties jdProperties, Properties info) throws SQLException {
        String secondaryUrl;
        AS400 as400 = null;
        boolean proxyServerWasSpecifiedInUrl = false;
        boolean proxyServerWasSpecifiedInProperties = false;
        boolean proxyServerWasSpecified = false;
        String driverImplementation = jdProperties.getString(41);
        if (!driverImplementation.equals("toolbox")) {
            if (nativeDriver == null) {
                try {
                    nativeDriver = (Driver)Class.forName("com.ibm.db2.jdbc.app.DB2Driver").newInstance();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation((Object)this, (String)"Native IBM Developer Kit for Java JDBC driver implementation was loaded");
                    }
                }
                catch (Throwable e) {
                    nativeDriver = null;
                }
            }
            if (nativeDriver != null && dataSourceUrl.getSecondaryURL().length() == 0) {
                boolean isLocal = false;
                String serverName = dataSourceUrl.getServerName();
                if (serverName.length() == 0 || serverName.equalsIgnoreCase("localhost")) {
                    isLocal = true;
                } else {
                    try {
                        InetAddress localInet = InetAddress.getLocalHost();
                        InetAddress[] remoteInet = InetAddress.getAllByName(serverName);
                        for (int i = 0; i < remoteInet.length; ++i) {
                            if (!localInet.equals(remoteInet[i])) continue;
                            isLocal = true;
                        }
                    }
                    catch (Throwable localInet) {
                        // empty catch block
                    }
                }
                if (isLocal) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation((Object)this, (String)"Connection is local");
                    }
                    String nativeURL = dataSourceUrl.getNativeURL();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation((Object)this, (String)"Using native IBM Developer Kit for Java JDBC driver implementation");
                    }
                    return nativeDriver.connect(nativeURL, info);
                }
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation((Object)this, (String)"Using IBM Toolbox for Java JDBC driver implementation");
        }
        if (jdProperties.getString(34).length() != 0) {
            proxyServerWasSpecifiedInUrl = true;
        }
        if (SystemProperties.getProperty((String)"com.ibm.as400.access.AS400.proxyServer") != null) {
            proxyServerWasSpecifiedInProperties = true;
        }
        if (proxyServerWasSpecifiedInUrl || proxyServerWasSpecifiedInProperties) {
            proxyServerWasSpecified = true;
        }
        if (!proxyServerWasSpecified && (secondaryUrl = dataSourceUrl.getSecondaryURL()).length() != 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation((Object)this, (String)("Secondary URL [" + secondaryUrl + "]"));
            }
            return DriverManager.getConnection(secondaryUrl, info);
        }
        as400 = AS400JDBCDriverForcedCcsid.initializeAS400(dataSourceUrl, jdProperties, info);
        if (proxyServerWasSpecifiedInUrl) {
            String proxyServerNameAndPort = jdProperties.getString(34);
            try {
                as400.setProxyServer(proxyServerNameAndPort);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return this.prepareConnection(as400, dataSourceUrl, info, jdProperties);
    }

    private Connection initializeConnection(AS400 as400) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(null);
        Properties info = new Properties();
        JDProperties jdProperties = new JDProperties(null, info);
        return this.prepareConnection(as400, dataSourceUrl, info, jdProperties);
    }

    private Connection initializeConnection(String schema, Properties info, AS400 as400) throws SQLException {
        boolean proxyServerWasSpecifiedInUrl = false;
        String url = null;
        url = schema != null ? "jdbc:as400://" + as400.getSystemName() + "/" + schema : "jdbc:as400://" + as400.getSystemName();
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        JDProperties jdProperties = new JDProperties(null, info);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation((Object)this, (String)"Using IBM Toolbox for Java JDBC driver implementation");
        }
        if (jdProperties.getString(34).length() != 0) {
            proxyServerWasSpecifiedInUrl = true;
        }
        if (proxyServerWasSpecifiedInUrl) {
            String proxyServerNameAndPort = jdProperties.getString(34);
            try {
                as400.setProxyServer(proxyServerNameAndPort);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return this.prepareConnection(as400, dataSourceUrl, info, jdProperties);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private Connection prepareConnection(AS400 as400, JDDataSourceURL dataSourceUrl, Properties info, JDProperties jdProperties) throws SQLException {
        Connection connection;
        SocketProperties sockProps = null;
        if (!jdProperties.getString(67).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setKeepAlive(jdProperties.getBoolean(67));
        }
        if (!jdProperties.getString(68).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setReceiveBufferSize(jdProperties.getInt(68));
        }
        if (!jdProperties.getString(69).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setSendBufferSize(jdProperties.getInt(69));
        }
        if (!as400.arePropertiesFrozen()) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setLoginTimeout(DriverManager.getLoginTimeout() * 1000);
        }
        if (!jdProperties.getString(58).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setLoginTimeout(jdProperties.getInt(58) * 1000);
        }
        if (!jdProperties.getString(81).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setSoTimeout(jdProperties.getInt(81));
        }
        if (jdProperties.getBoolean(100)) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setTcpNoDelay(true);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation((Object)this, (String)"Setting sockProps.setTcpNoDelay(true)");
            }
        }
        String defaultImpl = "com.ibm.as400.access.AS400JDBCConnectionForcedCcsid";
        if (jdProperties.getInt(93) == 1) {
            defaultImpl = "com.ibm.as400.access.AS400JDBCConnectionRedirect";
        }
        if (sockProps != null) {
            as400.setSocketProperties(sockProps);
        }
        if ((connection = (Connection)as400.loadImpl2(defaultImpl, "com.ibm.as400.access.JDConnectionProxy")) != null) {
            try {
                if (connection instanceof JDConnectionProxy) {
                    ((JDConnectionProxy)connection).setSystem(as400);
                    ((JDConnectionProxy)connection).setProperties(dataSourceUrl, jdProperties, as400);
                } else {
                    ((AS400JDBCConnection)connection).setSystem(as400);
                    ((AS400JDBCConnection)connection).setProperties(dataSourceUrl, jdProperties, as400, info);
                }
            }
            catch (SQLException sqlex) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sqlex;
            }
        }
        return connection;
    }

    public String toString() {
        return DRIVER_NAME_;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        nativeDriver = null;
        try {
            if (Trace.traceOn_) {
                Trace.logLoadPath((String)CLASSNAME, (int)8);
            }
            AS400JDBCDriverRegistration.registerCcsidDriver();
            resources_ = ResourceBundle.getBundle("com.ibm.as400.access.JDMRI");
            resources2_ = ResourceBundle.getBundle("com.ibm.as400.access.JDMRI2");
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

