/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve.rnrn0200;

import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalReceiverInfo;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record DetailedJournalReceiver(JournalReceiverInfo info, BigInteger start, BigInteger end, Optional<JournalReceiver> nextReceiver, long maxEntryLength, long numberOfEntries) {
    private static final Logger log = LoggerFactory.getLogger(DetailedJournalReceiver.class);

    public DetailedJournalReceiver withStatus(JournalStatus status) {
        return new DetailedJournalReceiver(this.info().withStatus(status), this.start, this.end, this.nextReceiver, this.maxEntryLength, this.numberOfEntries);
    }

    public boolean isSameReceiver(JournalProcessedPosition position) {
        if (this.info == null || position == null) {
            return false;
        }
        return this.info.receiver().equals(position.getReceiver());
    }

    public boolean isSameReceiver(DetailedJournalReceiver otherReceiver) {
        if (this.info == null || otherReceiver == null || otherReceiver.info() == null) {
            return false;
        }
        return this.info.receiver().equals(otherReceiver.info().receiver());
    }

    public boolean isAttached() {
        if (this.info != null) {
            return JournalStatus.Attached.equals((Object)this.info.status());
        }
        return false;
    }

    public static List<DetailedJournalReceiver> lastJoined(List<DetailedJournalReceiver> list) {
        List<DetailedJournalReceiver> attached = list.stream().filter(x -> {
            if (x.info().attachTime() != null) {
                return true;
            }
            log.info("deleting journal {} will null start time", x);
            return false;
        }).collect(Collectors.toList());
        attached.sort((f, s) -> f.info().attachTime().compareTo(s.info().attachTime()));
        int last = DetailedJournalReceiver.indexOfLastJoined(attached);
        if (last == 0) {
            return attached;
        }
        if (last >= attached.size()) {
            log.warn("no available receivers");
            return Collections.emptyList();
        }
        log.info("restricting as receiver is unavailble {}", (Object)attached.get(last - 1));
        return attached.subList(last, attached.size());
    }

    public static int indexOfLastJoined(List<DetailedJournalReceiver> list) {
        int size = list.size();
        int last = 0;
        for (int i = 0; i < size; ++i) {
            if (list.get(i).isJoined()) continue;
            last = i + 1;
        }
        return last;
    }

    public boolean isJoined() {
        return DetailedJournalReceiver.isJoined(this.info.status());
    }

    public static boolean isJoined(JournalStatus status) {
        return switch (status) {
            case JournalStatus.Attached, JournalStatus.OnlineSavedDetached, JournalStatus.SavedDetchedNotFreed -> true;
            default -> false;
        };
    }
}

