/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import io.debezium.ibmi.db2.journal.retrieve.JournalPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Objects;

public class JournalProcessedPosition {
    private BigInteger offset;
    private JournalReceiver receiver;
    private Instant timeOfLastProcessed = Instant.EPOCH;
    private boolean processed = false;
    private static String[] empty = new String[0];

    public JournalProcessedPosition(JournalProcessedPosition position) {
        this.offset = position.offset;
        this.receiver = position.receiver;
        this.processed = position.processed;
        this.timeOfLastProcessed = position.timeOfLastProcessed;
    }

    public JournalProcessedPosition() {
    }

    public JournalProcessedPosition(JournalPosition p, Instant time, boolean processed) {
        this(p.getOffset(), p.getReceiver(), time, processed);
    }

    public JournalPosition asJournalPosition() {
        return new JournalPosition(this.offset, this.receiver);
    }

    public boolean processed() {
        return this.processed;
    }

    public JournalProcessedPosition(String offsetStr, String receiver, String receiverLibrary, Instant time, boolean processed) {
        this.offset = offsetStr == null || offsetStr.isBlank() ? null : new BigInteger(offsetStr);
        this.receiver = new JournalReceiver(StringHelpers.safeTrim(receiver), StringHelpers.safeTrim(receiverLibrary));
        this.timeOfLastProcessed = time;
        this.processed = processed;
    }

    public JournalProcessedPosition(BigInteger offset, JournalReceiver receiver, Instant time, boolean processed) {
        this.offset = offset;
        this.receiver = receiver;
        this.timeOfLastProcessed = time;
        this.processed = processed;
    }

    public BigInteger getOffset() {
        if (null == this.offset) {
            return BigInteger.ZERO;
        }
        return this.offset;
    }

    public Instant getTimeOfLastProcessed() {
        return this.timeOfLastProcessed;
    }

    public boolean isOffsetSet() {
        return null != this.offset;
    }

    public JournalReceiver getReceiver() {
        return this.receiver;
    }

    public String[] getJournal() {
        if (this.receiver.name() != null && this.receiver.library() != null) {
            return new String[]{this.receiver.name(), this.receiver.library(), this.receiver.name(), this.receiver.library()};
        }
        return empty;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.processed, this.receiver);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JournalProcessedPosition other = (JournalProcessedPosition)obj;
        return Objects.equals(this.offset, other.offset) && this.processed == other.processed && Objects.equals(this.receiver, other.receiver);
    }

    public String toString() {
        return String.format("JournalProcessedPosition [offset=%s, receiver=%s, timeOfLastProcessed=%s, processed=%s]", this.offset, this.receiver, this.timeOfLastProcessed, this.processed);
    }

    public JournalProcessedPosition setOffset(BigInteger offset, Instant time, boolean processed) {
        this.offset = offset;
        this.processed = processed;
        this.timeOfLastProcessed = time;
        return this;
    }

    public JournalProcessedPosition setProcessed(boolean processed) {
        this.processed = processed;
        return this;
    }

    public void setJournalReceiver(BigInteger offset, String journalReceiver, String schema, Instant time, boolean processed) {
        this.offset = offset;
        this.receiver = new JournalReceiver(StringHelpers.safeTrim(journalReceiver), StringHelpers.safeTrim(schema));
        this.processed = processed;
        this.timeOfLastProcessed = time;
    }

    public void setPosition(JournalProcessedPosition newPosition) {
        this.offset = newPosition.offset;
        this.receiver = newPosition.receiver;
        if (!newPosition.timeOfLastProcessed.equals(Instant.EPOCH)) {
            this.timeOfLastProcessed = newPosition.timeOfLastProcessed;
        }
        this.processed = newPosition.processed;
    }

    public void setPosition(JournalPosition newPosition, boolean processed) {
        this.offset = newPosition.getOffset();
        this.receiver = newPosition.receiver();
        this.processed = processed;
    }

    public JournalProcessedPosition withOffset(BigInteger offset, boolean processed) {
        return new JournalProcessedPosition(offset, this.receiver, this.timeOfLastProcessed, processed);
    }

    public boolean isSameReceiver(DetailedJournalReceiver other) {
        if (this.receiver == null || other.info() == null) {
            return false;
        }
        return this.receiver.equals(other.info().receiver());
    }
}

