/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import io.debezium.ibmi.db2.journal.retrieve.Connect;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesPerChar {
    private static final String GET_OCTET_LENGTH = "select table_name, system_table_name, column_name, system_column_name, length, character_octet_length FROM qsys2.SYSCOLUMNS where table_schema=? and (system_table_name = ? or table_name = ?)";
    private final Map<String, Integer> octetLenghtMap = new HashMap<String, Integer>();
    private final Connect<Connection, SQLException> jdbcConnect;
    static final Logger log = LoggerFactory.getLogger(BytesPerChar.class);

    public BytesPerChar(Connect<Connection, SQLException> jdbcConnect) {
        this.jdbcConnect = jdbcConnect;
    }

    public Integer getBytesPerChar(String schema, String table, String columnName) {
        String canonicalName = String.format("%s.%s.%s", schema, table, columnName);
        if (this.octetLenghtMap.containsKey(canonicalName)) {
            return this.octetLenghtMap.get(canonicalName);
        }
        try {
            this.fetchAllOctetLengthForTable(schema, table);
            return this.octetLenghtMap.get(canonicalName);
        }
        catch (SQLException e) {
            log.error("failed to fetch octet length", (Throwable)e);
            return -1;
        }
    }

    private void fetchAllOctetLengthForTable(String schema, String table) throws SQLException {
        Connection con = this.jdbcConnect.connection();
        try (PreparedStatement ps = con.prepareStatement(GET_OCTET_LENGTH);){
            ps.setString(1, schema.toUpperCase());
            ps.setString(2, table.toUpperCase());
            ps.setString(3, table.toUpperCase());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String longTableName = StringHelpers.safeTrim(rs.getString(1));
                    String shortTableName = StringHelpers.safeTrim(rs.getString(2));
                    String longcolumn = StringHelpers.safeTrim(rs.getString(3));
                    String shortcolumn = StringHelpers.safeTrim(rs.getString(4));
                    int length = rs.getInt(5);
                    int octetLength = rs.getInt(6);
                    this.add(schema, longTableName, longcolumn, length, octetLength);
                    this.add(schema, shortTableName, shortcolumn, length, octetLength);
                }
            }
        }
    }

    public void add(String schema, String table, String column, int length, int octetLength) {
        String canonicalLongName = String.format("%s.%s.%s", schema, table, column);
        int bytesPerChar = octetLength / length;
        bytesPerChar = bytesPerChar < 1 ? 1 : bytesPerChar;
        log.debug("bytes per char {} {} {} {}", new Object[]{schema, table, column, bytesPerChar});
        this.octetLenghtMap.put(canonicalLongName, bytesPerChar);
    }
}

