/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import io.debezium.ibmi.db2.journal.retrieve.JournalEntryDeocder;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfoRetrieval;
import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.ParameterListBuilder;
import io.debezium.ibmi.db2.journal.retrieve.PositionRange;
import io.debezium.ibmi.db2.journal.retrieve.ReceiverPagination;
import io.debezium.ibmi.db2.journal.retrieve.RetrievalCriteria;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveConfig;
import io.debezium.ibmi.db2.journal.retrieve.exception.InvalidJournalFilterException;
import io.debezium.ibmi.db2.journal.retrieve.exception.InvalidPositionException;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.EntryHeader;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.EntryHeaderDecoder;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.FirstHeader;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.FirstHeaderDecoder;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.OffsetStatus;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveJournal {
    private static final Logger log = LoggerFactory.getLogger(RetrieveJournal.class);
    private static final RetrievalCriteria.JournalCode[] REQUIRED_JOURNAL_CODES = new RetrievalCriteria.JournalCode[]{RetrievalCriteria.JournalCode.D, RetrievalCriteria.JournalCode.R, RetrievalCriteria.JournalCode.C};
    private static final RetrievalCriteria.JournalEntryType[] REQURED_ENTRY_TYPES = new RetrievalCriteria.JournalEntryType[]{RetrievalCriteria.JournalEntryType.PT, RetrievalCriteria.JournalEntryType.PX, RetrievalCriteria.JournalEntryType.UP, RetrievalCriteria.JournalEntryType.UB, RetrievalCriteria.JournalEntryType.DL, RetrievalCriteria.JournalEntryType.DR, RetrievalCriteria.JournalEntryType.CT, RetrievalCriteria.JournalEntryType.CG, RetrievalCriteria.JournalEntryType.SC, RetrievalCriteria.JournalEntryType.CM};
    private static final FirstHeaderDecoder firstHeaderDecoder = new FirstHeaderDecoder();
    private static final EntryHeaderDecoder entryHeaderDecoder = new EntryHeaderDecoder();
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMdd-hhmm");
    private final ReceiverPagination journalReceivers;
    private final ParameterListBuilder builder = new ParameterListBuilder();
    RetrieveConfig config;
    private byte[] outputData = null;
    private FirstHeader header = null;
    private EntryHeader entryHeader = null;
    private int offset = -1;
    private JournalProcessedPosition position;
    private long totalTransferred = 0L;

    public RetrieveJournal(RetrieveConfig config, JournalInfoRetrieval journalRetrieval) {
        this.config = config;
        this.journalReceivers = new ReceiverPagination(journalRetrieval, config.maxServerSideEntries(), config.journalInfo());
        this.builder.withJournal(config.journalInfo().journalName(), config.journalInfo().journalLibrary());
    }

    public boolean retrieveJournal(JournalProcessedPosition previousPosition) throws Exception {
        PositionRange range = this.journalReceivers.findRange(this.config.as400().connection(), previousPosition);
        return this.retrieveJournal(previousPosition, range);
    }

    public boolean retrieveJournal(JournalProcessedPosition previousPosition, PositionRange range) throws Exception {
        this.offset = -1;
        this.entryHeader = null;
        this.position = new JournalProcessedPosition(previousPosition);
        if (range.startEqualsEnd()) {
            this.header = new FirstHeader(0, 0, 0, OffsetStatus.NOT_CALLED, new JournalProcessedPosition(range.end(), Instant.EPOCH, true));
            log.debug("start equals end - range {}", (Object)range);
            return true;
        }
        JournalProcessedPosition end = new JournalProcessedPosition(range.end(), Instant.EPOCH, true);
        ServiceProgramCall spc = new ServiceProgramCall(this.config.as400().connection());
        spc.getServerJob().setLoggingLevel(0);
        this.builder.init();
        this.builder.withBufferLenth(this.config.journalBufferSize());
        this.builder.withJournalEntryType(RetrievalCriteria.JournalEntryType.ALL);
        if (this.config.filtering() && !this.config.includeFiles().isEmpty()) {
            this.builder.withFileFilters(this.config.includeFiles());
        }
        this.builder.withRange(range);
        ProgramParameter[] parameters = this.builder.build();
        log.debug("Fetch journal position {} parameters {}", (Object)previousPosition, (Object)this.builder);
        spc.setProgram("/QSYS.LIB/QJOURNAL.SRVPGM", parameters);
        spc.setProcedureName("QjoRetrieveJournalEntries");
        spc.setAlignOn16Bytes(true);
        spc.setReturnValueFormat(1);
        boolean success = spc.run();
        if (success) {
            this.outputData = parameters[0].getOutputData();
            this.header = firstHeaderDecoder.decode(this.outputData, end);
            this.totalTransferred += (long)this.header.totalBytes();
            log.debug("first header: {} ", (Object)this.header);
            this.offset = -1;
            if (this.header.status() == OffsetStatus.MORE_DATA_NEW_OFFSET && this.header.offset() == 0) {
                log.error("buffer too small need to skip this entry {}", (Object)previousPosition);
                this.position.setPosition(this.header.nextPosition());
            }
            if (!this.hasData()) {
                this.position.setPosition(end);
            }
        } else {
            return this.reThrowIfFatal(previousPosition, spc, end, this.builder);
        }
        return success;
    }

    private boolean reThrowIfFatal(JournalProcessedPosition retrievePosition, ServiceProgramCall spc, JournalProcessedPosition latestJournalPosition, ParameterListBuilder builder) throws InvalidPositionException, InvalidJournalFilterException, RetrieveJournalException {
        for (AS400Message id : spc.getMessageList()) {
            String idt = id.getID();
            if (idt == null) {
                log.error("Call failed position {} parameters {} no Id, message: {}", new Object[]{retrievePosition, builder, id.getText()});
                continue;
            }
            switch (idt) {
                case "CPF7053": {
                    throw new InvalidPositionException(String.format("Call failed position %s parameters %s failed to find sequence or break in receivers: %s", retrievePosition, builder, this.getFullAS400MessageText(id)));
                }
                case "CPF9801": {
                    throw new InvalidPositionException(String.format("Call failed position %s parameters %s failed to find receiver: %s", retrievePosition, builder, this.getFullAS400MessageText(id)));
                }
                case "CPF7054": {
                    throw new InvalidPositionException(String.format("Call failed position %s parameters %s failed to find offset or invalid offsets: %s", retrievePosition, builder, id.getText()));
                }
                case "CPF7060": {
                    throw new InvalidJournalFilterException(String.format("Call failed position %s parameters %s object not found or not journaled: %s", retrievePosition, builder, this.getFullAS400MessageText(id)));
                }
                case "CPF7062": {
                    log.debug("Normal when filtering, call failed position {} parameters {} no data received: {}", new Object[]{retrievePosition, builder, id.getText()});
                    this.header = new FirstHeader(0, 0, 0, OffsetStatus.NO_DATA, latestJournalPosition);
                    this.position.setPosition(latestJournalPosition);
                    return true;
                }
            }
            log.error("Call failed position {} parameters {} with error code {} message {}", new Object[]{retrievePosition, idt, builder, this.getFullAS400MessageText(id)});
        }
        throw new RetrieveJournalException(String.format("Call failed position %s", retrievePosition));
    }

    boolean shouldLimitRange() {
        return this.config.filtering();
    }

    private String getFullAS400MessageText(AS400Message message) {
        try {
            message.load(1);
            return String.format("%s %s", message.getText(), message.getHelp());
        }
        catch (Exception e) {
            return message.getText();
        }
    }

    public JournalProcessedPosition getPosition() {
        return this.position;
    }

    public void setOutputData(byte[] b, FirstHeader header, JournalProcessedPosition position) {
        this.outputData = b;
        this.header = header;
        this.position = position;
    }

    public boolean hasData() {
        if (this.header.status() == OffsetStatus.NO_DATA) {
            return false;
        }
        if (this.offset < 0 && this.header.size() > 0) {
            return true;
        }
        return this.offset > 0 && this.entryHeader.getNextEntryOffset() > 0;
    }

    public boolean futureDataAvailable() {
        return this.header.hasFutureDataAvailable();
    }

    public boolean nextEntry() {
        if (this.offset < 0) {
            if (this.header.size() > 0) {
                this.offset = this.header.offset();
                this.entryHeader = entryHeaderDecoder.decode(this.outputData, this.offset);
                if (RetrieveJournal.alreadyProcessed(this.position, this.entryHeader)) {
                    log.debug("skipping already seen entry {} {}", (Object)this.position, (Object)this.entryHeader);
                    return this.nextEntry();
                }
                RetrieveJournal.updatePosition(this.position, this.entryHeader);
                return true;
            }
            return false;
        }
        long nextOffset = this.entryHeader.getNextEntryOffset();
        if (nextOffset > 0L) {
            this.offset += (int)nextOffset;
            this.entryHeader = entryHeaderDecoder.decode(this.outputData, this.offset);
            RetrieveJournal.updatePosition(this.position, this.entryHeader);
            return true;
        }
        this.updateOffsetFromContinuation();
        return false;
    }

    private void updateOffsetFromContinuation() {
        JournalProcessedPosition nextOffset = this.header.nextPosition();
        log.debug("Setting continuation offset {}", (Object)nextOffset);
        this.position.setPosition(nextOffset);
    }

    private static boolean alreadyProcessed(JournalProcessedPosition position, EntryHeader entryHeader) {
        JournalProcessedPosition entryPosition = new JournalProcessedPosition(position);
        return position.processed() && entryPosition.equals(position);
    }

    private static void updatePosition(JournalProcessedPosition p, EntryHeader entryHeader) {
        if (entryHeader.hasReceiver()) {
            log.debug("offset with receiver {}", (Object)entryHeader.getReceiver());
            p.setJournalReceiver(entryHeader.getSequenceNumber(), entryHeader.getReceiver(), entryHeader.getReceiverLibrary(), entryHeader.getTime(), true);
        } else {
            log.debug("offset no receiver {}", (Object)entryHeader);
            p.setOffset(entryHeader.getSequenceNumber(), entryHeader.getTime(), true);
        }
    }

    public EntryHeader getEntryHeader() {
        return this.entryHeader;
    }

    public void dumpEntry() {
        int start = this.offset + this.entryHeader.getEntrySpecificDataOffset();
        long end = this.entryHeader.getNextEntryOffset();
        log.debug("total offset {} entry specific offset {} next offset {}", new Object[]{start, this.entryHeader.getEntrySpecificDataOffset(), end});
    }

    public int getOffset() {
        return this.offset;
    }

    public <T> T decode(JournalEntryDeocder<T> decoder) throws Exception {
        try {
            T t = decoder.decode(this.entryHeader, this.outputData, this.offset);
            return t;
        }
        catch (Exception e) {
            this.dumpEntryToFile(this.config.dumpFolder());
            throw e;
        }
    }

    public void dumpEntryToFile(File path) {
        File dumpFile = null;
        if (path != null) {
            boolean created = false;
            for (int i = 0; !created && i < 100; ++i) {
                String formattedDate = this.dateFormatter.format(new Date());
                File f = new File(path, String.format("%s-%s", formattedDate, Integer.toString(i)));
                try {
                    created = f.createNewFile();
                    if (!created) continue;
                    dumpFile = f;
                    continue;
                }
                catch (IOException e) {
                    log.error("unable to dump to file", (Throwable)e);
                }
            }
            if (dumpFile != null) {
                try {
                    int start = this.offset;
                    int end = this.outputData.length;
                    byte[] bdata = Arrays.copyOfRange(this.outputData, start, end);
                    Files.write(dumpFile.toPath(), bdata, new OpenOption[0]);
                    File entryInfo = new File(dumpFile.getPath() + ".txt");
                    try (FileWriter fw = new FileWriter(entryInfo, true);
                         BufferedWriter bw = new BufferedWriter(fw);
                         PrintWriter out = new PrintWriter(bw);){
                        out.println(this.entryHeader.toString());
                        out.print("dumped: ");
                        out.println(end - start);
                        out.print("total length: ");
                        out.println(this.outputData.length);
                    }
                }
                catch (IOException e) {
                    log.error("failed to dump problematic data", (Throwable)e);
                }
            } else {
                log.error("failed to create a dump file");
            }
        }
    }

    public FirstHeader getFirstHeader() {
        return this.header;
    }

    public long getTotalTransferred() {
        return this.totalTransferred;
    }

    public static class RetrieveJournalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RetrieveJournalException(String message) {
            super(message);
        }
    }
}

