/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve.rnrn0200;

import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalReceiverInfo;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DetailedJournalReceiverTest {
    DetailedJournalReceiver dr3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("3", "lib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.empty(), 1L, 1L);
    DetailedJournalReceiver dr2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("2", "lib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ZERO, BigInteger.ONE, Optional.of(this.dr3.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("1", "lib"), new Date(1L), JournalStatus.Partial, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.of(this.dr2.info().receiver()), 1L, 1L);

    DetailedJournalReceiverTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
    }

    @Test
    void testLatestChain() {
        ArrayList<DetailedJournalReceiver> l = new ArrayList<DetailedJournalReceiver>(Arrays.asList(this.dr1));
        List<DetailedJournalReceiver> active = List.of(this.dr2, this.dr3);
        l.addAll(active);
        List firstChain = DetailedJournalReceiver.lastJoined(l);
        Assertions.assertEquals(active, (Object)firstChain);
    }

    @Test
    void testLatestChainSorting() {
        List<DetailedJournalReceiver> inactive = Arrays.asList(this.dr1);
        List<DetailedJournalReceiver> active = List.of(this.dr2, this.dr3);
        ArrayList<DetailedJournalReceiver> l = new ArrayList<DetailedJournalReceiver>(active);
        l.addAll(inactive);
        List firstChain = DetailedJournalReceiver.lastJoined(l);
        Assertions.assertEquals(active, (Object)firstChain);
    }

    @Test
    void testWithStatus() {
        DetailedJournalReceiver dr = this.dr1;
        DetailedJournalReceiver expected = new DetailedJournalReceiver(new JournalReceiverInfo(this.dr1.info().receiver(), this.dr1.info().attachTime(), JournalStatus.Attached, this.dr1.info().chain()), this.dr1.start(), this.dr1.end(), this.dr1.nextReceiver(), this.dr1.maxEntryLength(), this.dr1.numberOfEntries());
        Assertions.assertEquals((Object)expected, (Object)dr.withStatus(JournalStatus.Attached), (String)"only the status should change");
    }
}

