/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve.rnrn0200;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.FieldDescription;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.KeyHeader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDecoder {
    private static final Logger log = LoggerFactory.getLogger(KeyDecoder.class);
    private static final AS400Structure structure;

    public KeyHeader decode(byte[] data, int offset) {
        Object[] os = (Object[])structure.toObject(data, offset);
        return new KeyHeader((Integer)os[0], (Integer)os[1], (Integer)os[2], (Integer)os[3], (Integer)os[4]);
    }

    static {
        ArrayList<AS400DataType> dataTypes = new ArrayList<AS400DataType>();
        AS400Timestamp timeType = new AS400Timestamp();
        try {
            Field privateDTSFormat = AS400Timestamp.class.getDeclaredField("FORMAT_DTS");
            privateDTSFormat.setAccessible(true);
            int dtsformat = (Integer)privateDTSFormat.get(timeType);
            Method privateSetFormat = AS400Timestamp.class.getDeclaredMethod("setFormat", Integer.TYPE);
            privateSetFormat.setAccessible(true);
            privateSetFormat.invoke((Object)timeType, dtsformat);
        }
        catch (Exception e) {
            log.error("Failed to decode receiver data", (Throwable)e);
        }
        FieldDescription[] fds = new FieldDescription[]{new BinaryFieldDescription(new AS400Bin4(), "0 key"), new BinaryFieldDescription(new AS400Bin4(), "1 offset to key info"), new BinaryFieldDescription(new AS400Bin4(), "2 length of key info header"), new BinaryFieldDescription(new AS400Bin4(), "3 numer of entries"), new BinaryFieldDescription(new AS400Bin4(), "4 length of each entry")};
        for (int i = 0; i < fds.length; ++i) {
            dataTypes.add(fds[i].getDataType());
        }
        structure = new AS400Structure(dataTypes.toArray(new AS400DataType[dataTypes.size()]));
    }
}

