/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfo;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfoRetrieval;
import io.debezium.ibmi.db2.journal.retrieve.JournalPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.PositionRange;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverPagination {
    static final Logger log = LoggerFactory.getLogger(ReceiverPagination.class);
    private final JournalInfoRetrieval journalInfoRetrieval;
    private final JournalInfo journalInfo;
    private final BigInteger maxServerSideEntriesBI;
    private DetailedJournalReceiver cachedEndPosition;
    private List<DetailedJournalReceiver> cachedReceivers = null;

    ReceiverPagination(JournalInfoRetrieval journalInfoRetrieval, int maxServerSideEntries, JournalInfo journalInfo) {
        this.journalInfoRetrieval = journalInfoRetrieval;
        this.maxServerSideEntriesBI = BigInteger.valueOf(maxServerSideEntries);
        this.journalInfo = journalInfo;
    }

    PositionRange findRange(AS400 as400, JournalProcessedPosition startPosition) throws Exception {
        Optional<PositionRange> endOpt;
        BigInteger start = startPosition.getOffset();
        boolean fromBeginning = !startPosition.isOffsetSet() || start.equals(BigInteger.ZERO);
        DetailedJournalReceiver endPosition = this.journalInfoRetrieval.getCurrentDetailedJournalReceiver(as400, this.journalInfo);
        if (fromBeginning) {
            return new PositionRange(fromBeginning, startPosition, new JournalPosition(endPosition.end(), endPosition.info().receiver()));
        }
        if (this.cachedEndPosition == null) {
            this.cachedEndPosition = endPosition;
        }
        if (this.cachedReceivers == null) {
            this.cachedReceivers = this.journalInfoRetrieval.getReceivers(as400, this.journalInfo);
        }
        if (this.cachedEndPosition.isSameReceiver(endPosition)) {
            ReceiverPagination.updateEndPosition(this.cachedReceivers, endPosition);
            if (startPosition.isSameReceiver(endPosition)) {
                return this.paginateInSameReceiver(startPosition, endPosition, this.maxServerSideEntriesBI);
            }
        } else {
            this.cachedReceivers = this.journalInfoRetrieval.getReceivers(as400, this.journalInfo);
            this.cachedEndPosition = endPosition;
        }
        if ((endOpt = this.findPosition(startPosition, this.maxServerSideEntriesBI, this.cachedReceivers, this.cachedEndPosition)).isEmpty()) {
            log.warn("retrying to find end offset");
            this.cachedReceivers = this.journalInfoRetrieval.getReceivers(as400, this.journalInfo);
            endOpt = this.findPosition(startPosition, this.maxServerSideEntriesBI, this.cachedReceivers, endPosition);
        }
        log.debug("end {} journals {}", (Object)endPosition, this.cachedReceivers);
        return endOpt.orElseGet(() -> new PositionRange(fromBeginning, startPosition, new JournalPosition(endPosition.end(), endPosition.info().receiver())));
    }

    static void updateEndPosition(List<DetailedJournalReceiver> list, DetailedJournalReceiver endPosition) {
        for (int i = list.size() - 1; i >= 0; --i) {
            DetailedJournalReceiver d = list.get(i);
            if (!d.isSameReceiver(endPosition)) continue;
            list.set(i, endPosition);
            return;
        }
        list.add(endPosition);
    }

    PositionRange paginateInSameReceiver(JournalProcessedPosition startPosition, DetailedJournalReceiver endJournalPosition, BigInteger maxServerSideEntriesBI) throws Exception {
        if (!startPosition.isSameReceiver(endJournalPosition)) {
            throw new Exception(String.format("Error this method is only valid for same receiver start %s, end %s", startPosition, endJournalPosition));
        }
        BigInteger diff = endJournalPosition.end().subtract(startPosition.getOffset());
        if (diff.compareTo(maxServerSideEntriesBI) > 0) {
            BigInteger restricted = startPosition.getOffset().add(maxServerSideEntriesBI);
            return new PositionRange(false, startPosition, new JournalPosition(restricted, startPosition.getReceiver()));
        }
        return new PositionRange(false, startPosition, new JournalPosition(endJournalPosition.end(), startPosition.getReceiver()));
    }

    Optional<PositionRange> findPosition(JournalProcessedPosition startPosition, BigInteger maxEntries, List<DetailedJournalReceiver> receivers, DetailedJournalReceiver endPosition) {
        if (!this.containsEndPosition(receivers, endPosition)) {
            log.warn("unable to find active journal {} in receiver list", (Object)endPosition);
            return Optional.empty();
        }
        RangeFinder finder = new RangeFinder(startPosition, maxEntries);
        for (int i = 0; i < receivers.size(); ++i) {
            Optional<PositionRange> range = finder.next(receivers.get(i));
            if (!range.isPresent()) continue;
            return range;
        }
        Optional<PositionRange> range = finder.endRange();
        if (!finder.startFound()) {
            log.warn("Current position {} not found in available receivers {}", (Object)startPosition, receivers);
        }
        return range;
    }

    boolean containsEndPosition(List<DetailedJournalReceiver> receivers, DetailedJournalReceiver endPosition) {
        boolean containsEndPosition = false;
        for (int i = receivers.size() - 1; i >= 0; --i) {
            if (!receivers.get(i).info().receiver().equals(endPosition.info().receiver())) continue;
            containsEndPosition = true;
        }
        return containsEndPosition;
    }

    static class RangeFinder {
        private boolean found = false;
        private DetailedJournalReceiver lastReceiver = null;
        private BigInteger remaining;
        private final JournalProcessedPosition startPosition;

        RangeFinder(JournalProcessedPosition startPosition, BigInteger maxEntries) {
            this.remaining = maxEntries;
            this.startPosition = startPosition;
        }

        public Optional<PositionRange> next(DetailedJournalReceiver nextReceiver) {
            Optional<PositionRange> r;
            if (this.found) {
                if (this.lastReceiver != null && nextReceiver.start().compareTo(this.lastReceiver.end()) < 0) {
                    if (this.startEqualsEndAndProcessed(this.startPosition, this.lastReceiver)) {
                        this.startPosition.setPosition(new JournalPosition(nextReceiver.start(), nextReceiver.info().receiver()), false);
                    } else {
                        Optional<PositionRange> paginated = this.rangeWithinCurrentPosition(this.lastReceiver, this.startPosition.getOffset());
                        if (paginated.isPresent()) {
                            return paginated;
                        }
                        return Optional.of(new PositionRange(false, this.startPosition, new JournalPosition(this.lastReceiver.end(), this.lastReceiver.info().receiver())));
                    }
                }
                if ((r = this.rangeWithinCurrentPosition(nextReceiver, nextReceiver.start())).isPresent()) {
                    return r;
                }
            }
            if (nextReceiver.isSameReceiver(this.startPosition)) {
                this.found = true;
                r = this.rangeWithinCurrentPosition(nextReceiver, this.startPosition.getOffset());
                if (r.isPresent()) {
                    return r;
                }
            }
            this.lastReceiver = nextReceiver;
            return Optional.empty();
        }

        private Optional<PositionRange> rangeWithinCurrentPosition(DetailedJournalReceiver nextReceiver, BigInteger currentOffset) {
            BigInteger difference = nextReceiver.end().subtract(currentOffset);
            BigInteger entriesInJournal = difference.add(BigInteger.ONE);
            if (this.remaining.compareTo(difference) <= 0) {
                BigInteger offset = currentOffset.add(this.remaining);
                return Optional.of(new PositionRange(false, this.startPosition, new JournalPosition(offset, nextReceiver.info().receiver())));
            }
            this.remaining = this.remaining.subtract(entriesInJournal);
            return Optional.empty();
        }

        public Optional<PositionRange> endRange() {
            if (this.found && this.lastReceiver != null) {
                return Optional.of(new PositionRange(false, this.startPosition, JournalPosition.endPosition(this.lastReceiver)));
            }
            return Optional.empty();
        }

        public boolean startFound() {
            return this.found;
        }

        private boolean startEqualsEndAndProcessed(JournalProcessedPosition start, DetailedJournalReceiver last) {
            return start.processed() && start.getOffset().equals(last.end());
        }
    }
}

