/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400UnsignedBin4;
import io.debezium.ibmi.db2.journal.retrieve.JournalEntryDeocder;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.EntryHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JournalFileEntryDecoder
implements JournalEntryDeocder<Object[]> {
    static final Logger log = LoggerFactory.getLogger(JournalEntryDeocder.class);
    static final AS400UnsignedBin4 NullIndicatorLengthDecoder = new AS400UnsignedBin4();

    public abstract Object[] decodeFile(EntryHeader var1, byte[] var2, int var3) throws Exception;

    @Override
    public Object[] decode(EntryHeader entryHeader, byte[] data, int offset) throws Exception {
        Object[] objs = this.decodeFile(entryHeader, data, offset);
        Object[] nullified = this.nullify(objs, entryHeader, data, offset);
        return nullified;
    }

    Object[] nullify(Object[] objs, EntryHeader entryHeader, byte[] data, int offset) {
        boolean[] isNull = this.getNullFieldIndicators(data, entryHeader.getNullValueOffest(), offset);
        if (isNull == null) {
            return objs;
        }
        int length = Math.min(objs.length, isNull.length);
        for (int i = 0; i < length; ++i) {
            if (!isNull[i]) continue;
            objs[i] = null;
        }
        return objs;
    }

    private boolean[] getNullFieldIndicators(byte[] data, int nullEntryOffset, int offset) {
        boolean[] isNull = null;
        if (nullEntryOffset != 0) {
            long l = NullIndicatorLengthDecoder.toLong(data, offset + nullEntryOffset);
            if (l > Integer.MAX_VALUE) {
                log.error("null indicator length unreasonably large {}", (Object)l);
                return null;
            }
            int length = (int)l;
            isNull = new boolean[length];
            for (int i = 0; i < length; ++i) {
                isNull[i] = (data[offset + nullEntryOffset + 4 + i] & 0xF) == 1;
            }
        }
        return isNull;
    }
}

