/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import java.util.HashMap;
import java.util.Map;

public enum JournalEntryType {
    ADD_ROW2("R.PT"),
    ADD_ROW1("R.PX"),
    AFTER_IMAGE("R.UP"),
    ROLLBACK_AFTER_IMAGE("R.UR"),
    BEFORE_IMAGE("R.UB"),
    ROLLBACK_BEFORE_IMAGE("R.BR"),
    DELETE_ROW1("R.DR"),
    DELETE_ROW2("R.DL"),
    ROLLBACK_DELETE_ROW("R.DR"),
    FILE_CREATED("D.CT"),
    FILE_CHANGE("D.CG"),
    START_COMMIT("C.SC"),
    END_COMMIT("C.CM"),
    OPEN("F.OP"),
    CLOSE("F.CL");

    public final String code;
    private static final Map<String, JournalEntryType> BY_LABEL;

    private JournalEntryType(String code) {
        this.code = code;
    }

    public static JournalEntryType toValue(String code) {
        if (code == null) {
            return null;
        }
        return BY_LABEL.get(code);
    }

    static {
        BY_LABEL = new HashMap<String, JournalEntryType>();
        for (JournalEntryType e : JournalEntryType.values()) {
            BY_LABEL.put(e.code, e);
        }
    }
}

