/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.data.types;

import com.ibm.as400.access.AS400Text;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Diagnostics {
    private static final Logger log = LoggerFactory.getLogger(Diagnostics.class);

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static void dumpToFile(String filename, byte[] data, int offset, int length) throws IOException {
        byte[] bdata = Arrays.copyOfRange(data, offset, offset + length);
        try (FileOutputStream fos = new FileOutputStream(filename);){
            fos.write(bdata);
        }
    }

    public static String binAsHex(byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%04d: ", offset));
        for (int j = 0; j < length; ++j) {
            byte b = data[j + offset];
            sb.append(String.format("%02x ", b));
            if ((j + 1) % 80 != 0) continue;
            sb.append("\n");
            sb.append(String.format("%04d: ", j + offset));
        }
        return sb.toString();
    }

    public static String binAsAscii(byte[] data, int offset, int length) {
        byte[] bdata = Arrays.copyOfRange(data, offset, offset + length);
        StringBuilder sb = new StringBuilder("\n");
        int i = 0;
        for (byte b : bdata) {
            char c = (char)b;
            if (Diagnostics.isPrintableChar(c)) {
                sb.append(c);
            } else {
                sb.append(".");
            }
            if (++i % 80 != 0) continue;
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String binAsEbcdic(byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        AS400Text td = new AS400Text(1);
        sb.append(String.format("%04d: ", offset));
        for (int j = 0; j < length; ++j) {
            String s = (String)td.toObject(data, j + offset);
            if (Diagnostics.isPrintableChar(s.charAt(0))) {
                sb.append(s);
            } else {
                sb.append(".");
            }
            if ((j + 1) % 80 != 0) continue;
            sb.append("\n");
            sb.append(String.format("%04d: ", j + offset));
        }
        sb.append("\n");
        return sb.toString();
    }
}

