/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.test;

import com.ibm.as400.access.AS400;
import io.debezium.ibmi.db2.journal.retrieve.Connect;
import io.debezium.ibmi.db2.journal.retrieve.FileFilter;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfo;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfoRetrieval;
import io.debezium.ibmi.db2.journal.retrieve.JournalPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveConfig;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveConfigBuilder;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveJournal;
import io.debezium.ibmi.db2.journal.retrieve.SchemaCacheHash;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.test.TestConnector;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalFilterTimeout {
    private static final Logger log = LoggerFactory.getLogger(JournalFilterTimeout.class);
    private static SchemaCacheHash schemaCache = new SchemaCacheHash();

    public static void main(String[] args) throws Exception {
        TestConnector connector = new TestConnector();
        Connect<AS400, IOException> as400Connect = connector.getAs400();
        Connect<Connection, SQLException> sqlConnect = connector.getJdbc();
        String schema = connector.getSchema();
        ArrayList<FileFilter> includes = new ArrayList<FileFilter>();
        String includesEnv = System.getenv("ISERIES_INCLUDES");
        if (includesEnv != null) {
            for (String i : Arrays.asList(includesEnv.split(","))) {
                includes.add(new FileFilter(schema, i));
            }
        }
        JournalInfo journal = JournalInfoRetrieval.getJournal(as400Connect.connection(), schema, includes);
        String offset = System.getenv("ISERIES_OFFSET");
        String receiver = System.getenv("ISERIES_RECEIVER");
        JournalInfoRetrieval journalInfoRetrieval = new JournalInfoRetrieval();
        List<DetailedJournalReceiver> receivers = journalInfoRetrieval.getReceivers(as400Connect.connection(), journal);
        DetailedJournalReceiver first = (DetailedJournalReceiver)receivers.stream().min((x, y) -> x.start().compareTo(y.start())).get();
        JournalPosition endPosition = journalInfoRetrieval.getCurrentPosition(as400Connect.connection(), journal);
        log.info("start {} end {}", (Object)first, (Object)endPosition);
        try (PrintWriter pw = new PrintWriter(new File("exceptions.txt"));){
            log.info("journal: {}", (Object)journal);
            RetrieveConfig config = new RetrieveConfigBuilder().withAs400(as400Connect).withJournalInfo(journal).withDumpFolder("./bad-journal").withServerFiltering(true).withIncludeFiles(includes).build();
            RetrieveJournal rj = new RetrieveJournal(config, journalInfoRetrieval);
            JournalProcessedPosition p = new JournalProcessedPosition(first.start(), first.info().receiver(), Instant.ofEpochSecond(0L), false);
            long start = System.currentTimeMillis();
            boolean success = rj.retrieveJournal(p);
            long end = System.currentTimeMillis();
            log.info("success: {} position: {} time: {} ", new Object[]{success, rj.getPosition(), (double)(end - start) / 1000.0});
        }
    }
}

