/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.AS400ZonedDecimal;
import io.debezium.ibmi.db2.journal.data.types.AS400VarBin;
import io.debezium.ibmi.db2.journal.data.types.AS400VarChar;
import io.debezium.ibmi.db2.journal.data.types.AS400Xml;
import io.debezium.ibmi.db2.journal.retrieve.BytesPerChar;
import io.debezium.ibmi.db2.journal.retrieve.CcsidCache;
import io.debezium.ibmi.db2.journal.retrieve.Connect;
import io.debezium.ibmi.db2.journal.retrieve.JournalFileEntryDecoder;
import io.debezium.ibmi.db2.journal.retrieve.SchemaCacheIF;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.EntryHeader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcFileDecoder
extends JournalFileEntryDecoder {
    private static final AS400Float8 AS400_FLOAT8 = new AS400Float8();
    private static final AS400Float4 AS400_FLOAT4 = new AS400Float4();
    private static final AS400Time AS400_TIME = new AS400Time();
    private static final AS400Date AS400_DATE = new AS400Date();
    private static final AS400Timestamp AS400_TIMESTAMP = new AS400Timestamp();
    private static final AS400Xml AS400_XML = new AS400Xml();
    private static final AS400Bin8 AS400_BIN8 = new AS400Bin8();
    private static final AS400Bin4 AS400_BIN4 = new AS400Bin4();
    private static final AS400Bin2 AS400_BIN2 = new AS400Bin2();
    private static final String GET_DATABASE_NAME = "values ( CURRENT_SERVER )";
    private static final String UNIQUE_KEYS = "SELECT c.column_name FROM qsys.QADBKATR k\n      INNER JOIN qsys2.SYSCOLUMNS c on c.table_schema=k.dbklib and c.system_table_name=k.dbkfil AND c.system_column_name=k.DBKFLD\n      WHERE k.dbklib=? AND k.dbkfil=? ORDER BY k.DBKPOS ASC\n";
    private final Connect<Connection, SQLException> jdbcConnect;
    private final String databaseName;
    private final SchemaCacheIF schemaCache;
    private final CcsidCache ccsidCache;
    private final BytesPerChar octetLengthCache;
    private static final AS400Text LENGTH_DECODER = new AS400Text(5);
    private static final Object[] EMPTY = new Object[0];
    private static final String GET_TABLE_NAME = "select table_name from qsys2.systables where table_schema=? AND system_table_name=?";
    private final Map<String, Optional<String>> systemToLongName = new HashMap<String, Optional<String>>();
    static final Pattern BIT_DATA = Pattern.compile("CHAR \\(([(0-9]*)\\) FOR BIT DATA");
    static final Pattern VAR_BIT_DATA = Pattern.compile("VARCHAR \\(([(0-9]*)\\) FOR BIT DATA");

    public JdbcFileDecoder(Connect<Connection, SQLException> con, String database, SchemaCacheIF schemaCache, Integer fromCcsid, Integer toCcsid) {
        this.jdbcConnect = con;
        this.schemaCache = schemaCache;
        this.databaseName = database;
        this.ccsidCache = new CcsidCache(con, fromCcsid, toCcsid);
        this.octetLengthCache = new BytesPerChar(con);
    }

    @Override
    public Object[] decodeFile(EntryHeader entryHeader, byte[] data, int offset) throws Exception {
        Optional<SchemaCacheIF.TableInfo> tableInfoOpt = this.getRecordFormat(entryHeader.getFile(), entryHeader.getLibrary());
        return tableInfoOpt.map(tableInfo -> {
            String lengthStr = (String)LENGTH_DECODER.toObject(data, offset + entryHeader.getEntrySpecificDataOffset());
            int length = Integer.parseInt(lengthStr);
            if (length > 0) {
                Object[] os = this.decodeEntry(tableInfo.getAs400Structure(), data, offset + entryHeader.getEntrySpecificDataOffset() + 16);
                return os;
            }
            log.error("Empty journal entry for {}.{} is (before image) journalling set corretly for this table?", (Object)entryHeader.getLibrary(), (Object)entryHeader.getFile());
            return EMPTY;
        }).orElse(EMPTY);
    }

    public Object[] decodeEntry(AS400Structure entryDetailStructure, byte[] data, int offset) {
        Object[] result = (Object[])entryDetailStructure.toObject(data, offset);
        return result;
    }

    public static String getDatabaseName(Connection con) throws SQLException {
        try (PreparedStatement st = con.prepareStatement(GET_DATABASE_NAME);){
            String string;
            block16: {
                ResultSet rs;
                block14: {
                    String string2;
                    block15: {
                        rs = st.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            string2 = StringHelpers.safeTrim(rs.getString(1));
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = "";
                if (rs == null) break block16;
                rs.close();
            }
            return string;
        }
    }

    public void clearCache(String systemTableName, String schema) {
        String longTableName = this.getLongName(schema, systemTableName).orElse(systemTableName);
        this.schemaCache.clearCache(this.databaseName, schema, longTableName);
    }

    public Optional<SchemaCacheIF.TableInfo> getRecordFormat(String systemTableName, String schema) {
        Optional<SchemaCacheIF.TableInfo> optional;
        block11: {
            String longTableName = this.getLongName(schema, systemTableName).orElse(systemTableName);
            SchemaCacheIF.TableInfo tableInfo = this.schemaCache.retrieve(this.databaseName, schema, longTableName);
            if (tableInfo != null) {
                return Optional.of(tableInfo);
            }
            log.info("missed cache fetching structure for {} {}", (Object)schema, (Object)systemTableName);
            String databaseCatalog = null;
            ArrayList<AS400DataType> as400structure = new ArrayList<AS400DataType>();
            ArrayList<SchemaCacheIF.Structure> jdbcStructure = new ArrayList<SchemaCacheIF.Structure>();
            Connection con = this.jdbcConnect.connection();
            DatabaseMetaData metadata = con.getMetaData();
            ResultSet columnMetadata = metadata.getColumns(databaseCatalog, schema, longTableName, null);
            try {
                while (columnMetadata.next()) {
                    String name = columnMetadata.getString(4);
                    String type = columnMetadata.getString(6);
                    int precision = columnMetadata.getInt(9);
                    int length = columnMetadata.getInt(7);
                    int jdcbType = columnMetadata.getInt(5);
                    boolean optional2 = JdbcFileDecoder.isNullable(columnMetadata.getInt(11));
                    int octectLength = columnMetadata.getInt(16);
                    int position = columnMetadata.getInt(17);
                    boolean autoInc = "YES".equalsIgnoreCase(columnMetadata.getString(23));
                    jdbcStructure.add(new SchemaCacheIF.Structure(name, type, jdcbType, length, precision, optional2, position, autoInc));
                    AS400DataType dataType = this.toDataType(schema, longTableName, name, type, length, precision);
                    as400structure.add(dataType);
                    this.octetLengthCache.add(schema, longTableName, name, length, octectLength);
                }
                AS400Structure entryDetailStructure = new AS400Structure(as400structure.toArray(new AS400DataType[as400structure.size()]));
                List<String> primaryKeys = this.primaryKeysFromMeta(longTableName, schema, databaseCatalog, metadata);
                if (primaryKeys.isEmpty()) {
                    primaryKeys = this.ddsPrimaryKeys(systemTableName, schema);
                }
                tableInfo = new SchemaCacheIF.TableInfo(jdbcStructure, primaryKeys, entryDetailStructure);
                this.schemaCache.store(this.databaseName, schema, longTableName, tableInfo);
                optional = Optional.of(tableInfo);
                if (columnMetadata == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (columnMetadata != null) {
                        try {
                            columnMetadata.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to retrieve table info for {} {}", new Object[]{schema, longTableName, e});
                    log.warn("No table structure found for {}", (Object)systemTableName);
                    return Optional.empty();
                }
            }
            columnMetadata.close();
        }
        return optional;
    }

    private List<String> ddsPrimaryKeys(String table, String schema) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        Connection con = this.jdbcConnect.connection();
        try (PreparedStatement ps = con.prepareStatement(UNIQUE_KEYS);){
            ps.setString(1, schema);
            ps.setString(2, table);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String columnName = StringHelpers.safeTrim(rs.getString(1));
                    primaryKeys.add(columnName);
                }
            }
        }
        return primaryKeys;
    }

    private List<String> primaryKeysFromMeta(String table, String schema, String databaseCatalog, DatabaseMetaData metadata) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try (ResultSet rs = metadata.getPrimaryKeys(databaseCatalog, schema, table);){
            while (rs.next()) {
                String columnName = StringHelpers.safeTrim(rs.getString(4));
                primaryKeys.add(columnName);
            }
        }
        return primaryKeys;
    }

    static boolean isNullable(int jdbcNullable) {
        return jdbcNullable == 1 || jdbcNullable == 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> getLongName(String schemaName, String systemName) {
        if (this.systemToLongName.containsKey(systemName)) {
            return this.systemToLongName.get(systemName);
        }
        try {
            Connection con = this.jdbcConnect.connection();
            try (PreparedStatement ps = con.prepareStatement(GET_TABLE_NAME);){
                ps.setString(1, schemaName);
                ps.setString(2, systemName);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        Optional<String> longTableName = Optional.of(StringHelpers.safeTrim(rs.getString(1)));
                        this.systemToLongName.put(systemName, longTableName);
                        Optional<String> optional = longTableName;
                        return optional;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("failed looking up long table name", (Throwable)e);
        }
        log.warn("No long table name found for {}", (Object)systemName);
        this.systemToLongName.put(systemName, Optional.empty());
        return Optional.empty();
    }

    AS400Text getText(int length, int ccsid) {
        if (ccsid != -1) {
            return new AS400Text(length, ccsid);
        }
        return new AS400Text(length);
    }

    AS400VarChar getVarText(int length, int bytesPerChar, Integer ccsid) {
        if (ccsid != -1) {
            return new AS400VarChar(length, bytesPerChar, ccsid);
        }
        return new AS400VarChar(length, bytesPerChar);
    }

    public AS400DataType toDataType(String schema, String table, String columnName, String type, int length, Integer precision) {
        switch (type) {
            case "DECIMAL": {
                return new AS400PackedDecimal(length, precision.intValue());
            }
            case "CHAR () FOR BIT DATA": {
                return new AS400ByteArray(length);
            }
            case "VARCHAR () FOR BIT DATA": {
                return new AS400VarBin(length);
            }
            case "CHAR": {
                return this.getText(length, this.ccsidCache.getCcsid(schema, table, columnName));
            }
            case "NCHAR": {
                return this.getText(length * this.octetLengthCache.getBytesPerChar(schema, table, columnName), this.ccsidCache.getCcsid(schema, table, columnName));
            }
            case "NVARCHAR": {
                return this.getVarText(length, this.octetLengthCache.getBytesPerChar(schema, table, columnName), this.ccsidCache.getCcsid(schema, table, columnName));
            }
            case "VGRAPH": {
                return this.getVarText(length, this.octetLengthCache.getBytesPerChar(schema, table, columnName), this.ccsidCache.getCcsid(schema, table, columnName));
            }
            case "TIMESTAMP": {
                return AS400_TIMESTAMP;
            }
            case "VARCHAR": {
                return this.getVarText(length, this.octetLengthCache.getBytesPerChar(schema, table, columnName), this.ccsidCache.getCcsid(schema, table, columnName));
            }
            case "NUMERIC": {
                return new AS400ZonedDecimal(length, precision.intValue());
            }
            case "DATE": {
                return AS400_DATE;
            }
            case "TIME": {
                return AS400_TIME;
            }
            case "REAL": {
                return AS400_FLOAT4;
            }
            case "DOUBLE": {
                return AS400_FLOAT8;
            }
            case "SMALLINT": {
                return AS400_BIN2;
            }
            case "INTEGER": {
                return AS400_BIN4;
            }
            case "BIGINT": {
                return AS400_BIN8;
            }
            case "BINARY": {
                return new AS400ByteArray(length);
            }
            case "VARBINARY": {
                return new AS400VarBin(length);
            }
            case "XML": {
                return AS400_XML;
            }
        }
        Optional<Integer> varLength = this.bitDataLengthFromRegex(type, length, VAR_BIT_DATA);
        if (varLength.isPresent()) {
            return new AS400VarBin(varLength.get());
        }
        Optional<Integer> fixedLenght = this.bitDataLengthFromRegex(type, length, BIT_DATA);
        if (fixedLenght.isPresent()) {
            return new AS400ByteArray(fixedLenght.get().intValue());
        }
        throw new IllegalArgumentException(String.format("Unsupported type %s for column %s", type, columnName));
    }

    private Optional<Integer> bitDataLengthFromRegex(String type, int length, Pattern regex) {
        Matcher matcher = regex.matcher(type);
        if (matcher.matches()) {
            String size = matcher.group(1);
            if (size.isEmpty()) {
                return Optional.of(length);
            }
            int l = Integer.parseInt(size);
            return Optional.of(l);
        }
        return Optional.empty();
    }
}

