/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.data.types;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import io.debezium.ibmi.db2.journal.data.types.Diagnostics;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS400Clob
implements AS400DataType {
    private static final Logger log = LoggerFactory.getLogger(AS400Clob.class);
    private static final String EMPTY_STRING = "";
    private final AS400 as400;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public AS400Clob(AS400 as400) {
        this.as400 = as400;
    }

    public int getByteLength() {
        return 44;
    }

    public Object getDefaultValue() {
        return EMPTY_STRING;
    }

    public int getInstanceType() {
        return 9;
    }

    public Class<?> getJavaType() {
        return String.class;
    }

    public byte[] toBytes(Object javaValue) {
        return EMPTY_BYTES;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        return 0;
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        return 0;
    }

    public Object toObject(byte[] data) {
        return this.toObject(data, 0);
    }

    private String getClob(long addressHigh, long addressLow, byte[] addressbyte, int length) throws Exception {
        byte[] hb = new AS400Bin8().toBytes(addressHigh);
        byte[] lb = new AS400Bin8().toBytes(addressLow);
        byte[] address16 = new byte[16];
        System.arraycopy(hb, 0, address16, 0, 8);
        System.arraycopy(lb, 0, address16, 8, 8);
        log.debug("addresss re-encoded {}", (Object)this.toHex(address16));
        log.debug("address raw {}", (Object)this.toHex(addressbyte));
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, length + 2), new ProgramParameter(2, addressbyte), new ProgramParameter(2, new AS400Bin4().toBytes(length))};
        ServiceProgramCall spc = new ServiceProgramCall(this.as400);
        spc.setProgram("/QSYS.LIB/MARTINT.LIB/RTVPTRDTA.SRVPGM", parameters);
        spc.setProcedureName("GETDATA");
        spc.setAlignOn16Bytes(true);
        spc.setReturnValueFormat(1);
        boolean success = spc.run();
        if (success) {
            byte[] data = parameters[0].getOutputData();
            int retrivedLength = (Integer)new AS400Bin4().toObject(data, 0);
            byte[] btext = Arrays.copyOfRange(data, 2, data.length);
            String text = new String(btext);
            log.debug(text);
            return text;
        }
        String msg = "call failed " + Arrays.asList(spc.getMessageList()).stream().map(AS400Message::getText).reduce(EMPTY_STRING, (a, s) -> a + s);
        log.debug(msg);
        throw new Exception(msg);
    }

    private String deleteClob(long addressHigh, long addressLow, byte[] addressbyte) throws Exception {
        byte[] hb = new AS400Bin8().toBytes(addressHigh);
        byte[] lb = new AS400Bin8().toBytes(addressLow);
        byte[] address16 = new byte[16];
        System.arraycopy(hb, 0, address16, 0, 8);
        System.arraycopy(lb, 0, address16, 8, 8);
        log.debug("addresss re-encoded {}", (Object)this.toHex(address16));
        log.debug("address raw {}", (Object)this.toHex(addressbyte));
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, new AS400Bin4().toBytes((int)addressLow))};
        ServiceProgramCall spc = new ServiceProgramCall(this.as400);
        spc.setProgram("/QSYS.LIB/QJOURNAL.SRVPGM", parameters);
        spc.setProcedureName("QjoDeletePointerHandle");
        spc.setAlignOn16Bytes(true);
        spc.setReturnValueFormat(1);
        log.debug("pre job: {}", (Object)spc.getServerJob());
        boolean success = spc.run();
        log.debug("post job: {}", (Object)spc.getServerJob());
        if (success) {
            return EMPTY_STRING;
        }
        String msg = String.format("call failed %s", Arrays.asList(spc.getMessageList()).stream().map(AS400Message::getText).reduce(EMPTY_STRING, (a, s) -> a + s));
        log.debug(msg);
        throw new Exception(msg);
    }

    public String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public Object toObject(byte[] data, int offset) {
        int alignment = 16 - (offset + 13) % 16;
        int relativeOffset = offset + 1 + alignment;
        int length = (Integer)new AS400Bin4().toObject(data, relativeOffset);
        long first = (Long)new AS400Bin8().toObject(data, relativeOffset + 12);
        long second = (Long)new AS400Bin8().toObject(data, relativeOffset + 20);
        log.debug("alignment {}", (Object)alignment);
        log.debug("alignment zero {}", (Object)((relativeOffset + 12) % 16));
        log.debug("length {}", (Object)length);
        log.debug("first {}", (Object)first);
        log.debug("second {}", (Object)second);
        log.debug(Diagnostics.binAsHex(data, offset, 44));
        byte[] addressbyte = Arrays.copyOfRange(data, relativeOffset + 12, relativeOffset + 28);
        try {
            log.debug(this.getClob(first, second, addressbyte, length));
        }
        catch (Exception e) {
            log.error("failed to get clob", (Throwable)e);
        }
        return EMPTY_STRING;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log((int)2, (String)"Unexpected CloneNotSupportedException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }
}

