/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.junit.Flaky;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.util.DockerUtils;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Flaky(value="DBZ-7507")
public class MongoDbReplicaSetAuthTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbReplicaSetAuthTest.class);
    public static final String AUTH_DATABASE = "admin";
    public static final String TEST_DATABASE_1 = "fstDB";
    public static final String TEST_USER = "testUser";
    public static final String TEST_PWD = "testSecret";
    public static final String TEST_DATABASE_2 = "sndDB";
    public static final String TEST_COLLECTION = "examples";
    private static MongoDbReplicaSet mongo;

    @BeforeAll
    static void beforeAll() {
        DockerUtils.enableFakeDnsIfRequired();
        mongo = MongoDbReplicaSet.replicaSet().authEnabled(true).build();
        LOGGER.info("Starting {}...", (Object)mongo);
        mongo.start();
        LOGGER.info("Setting up users");
        mongo.createUser(TEST_USER, TEST_PWD, AUTH_DATABASE, new String[]{"read:fstDB"});
    }

    @AfterAll
    static void afterAll() {
        DockerUtils.disableFakeDns();
        if (mongo != null) {
            mongo.stop();
        }
    }

    @BeforeEach
    void before() {
        this.setupDatabase((MongoDbDeployment)mongo, TEST_DATABASE_1);
        this.setupDatabase((MongoDbDeployment)mongo, TEST_DATABASE_2);
    }

    void setupDatabase(MongoDbDeployment mongo, String dbName) {
        try (MongoClient client = MongoClients.create((String)mongo.getConnectionString());){
            LOGGER.info("Connected to cluster: {}", (Object)client.getClusterDescription());
            MongoDatabase database = client.getDatabase(dbName);
            database.drop();
            MongoCollection collection = database.getCollection(TEST_COLLECTION);
            collection.insertOne((Object)Document.parse((String)"{example: true}"));
        }
    }

    @Test
    @Flaky(value="DBZ-7507")
    public void testCluster() {
        String noAuthConnectionString = mongo.getNoAuthConnectionString();
        LOGGER.info("Connecting to cluster without credentials: {}", (Object)noAuthConnectionString);
        try (MongoClient client = MongoClients.create((String)noAuthConnectionString);){
            LOGGER.info("Connected to cluster: {}", (Object)client.getClusterDescription());
            client.getDatabase(TEST_DATABASE_1).listCollectionNames();
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Unauthorized"});
        }
        String connectionString = mongo.getConnectionString();
        LOGGER.info("Connecting to cluster as root: {}", (Object)connectionString);
        try (MongoClient client = MongoClients.create((String)connectionString);){
            LOGGER.info("Connected to cluster: {}", (Object)client.getClusterDescription());
            client.getDatabase(TEST_DATABASE_1).listCollectionNames();
        }
        String authConnectionString = mongo.getAuthConnectionString(TEST_USER, TEST_PWD, AUTH_DATABASE);
        LOGGER.info("Connecting to cluster as {}: {}", (Object)TEST_USER, (Object)authConnectionString);
        try (MongoClient client = MongoClients.create((String)authConnectionString);){
            ArrayList names = new ArrayList();
            client.getDatabase(TEST_DATABASE_1).listCollectionNames().into(names);
            Assertions.assertThat(names).containsOnly((Object[])new String[]{TEST_COLLECTION});
        }
        try {
            client = MongoClients.create((String)authConnectionString);
            try {
                client.getDatabase(TEST_DATABASE_2).listCollectionNames().first();
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"not authorized"});
        }
    }
}

