/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util;

import io.debezium.testing.testcontainers.util.PooledPortResolver;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ParsingPortResolver
extends PooledPortResolver {
    public static ParsingPortResolver parseProperty(String property) {
        return ParsingPortResolver.parseProperty(property, null);
    }

    public static ParsingPortResolver parseProperty(String property, String defaultValue) {
        String value = System.getProperty(property, defaultValue);
        Objects.requireNonNull(value, "Property '" + property + "' is either undefined or null");
        return new ParsingPortResolver(System.getProperty(property, defaultValue));
    }

    public ParsingPortResolver(String value) {
        this(value, new ListParseStrategy(), new RangeParseStrategy());
    }

    public ParsingPortResolver(String value, ParseStrategy ... strategies) {
        this(value, ParsingPortResolver.matchingStrategy(value, strategies));
    }

    public ParsingPortResolver(String value, ParseStrategy strategy) {
        super(strategy.parse(value));
    }

    private static ParseStrategy matchingStrategy(String value, ParseStrategy ... strategies) {
        return Arrays.stream(strategies).filter(s -> s.matches(value)).findFirst().orElseThrow(() -> new IllegalStateException("No applicable parsing strategy"));
    }

    public static abstract class ParseStrategy {
        protected final Pattern pattern;

        public ParseStrategy(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(String value) {
            return this.pattern.asMatchPredicate().test(value);
        }

        public Set<Integer> parse(String value) {
            Matcher matcher = this.pattern.matcher(value);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid value '" + value + "'");
            }
            return this.doParse(matcher, value);
        }

        protected abstract Set<Integer> doParse(Matcher var1, String var2);
    }

    public static final class ListParseStrategy
    extends ParseStrategy {
        public static final Pattern PATTERN = Pattern.compile("^\\d+(,\\d+)*$");

        public ListParseStrategy() {
            super(PATTERN);
        }

        @Override
        protected Set<Integer> doParse(Matcher matcher, String value) {
            return Arrays.stream(value.split(",")).map(Integer::parseInt).collect(Collectors.toSet());
        }
    }

    public static final class RangeParseStrategy
    extends ParseStrategy {
        public static final Pattern PATTERN = Pattern.compile("^(?<from>\\d+):(?<to>\\d+)$");

        public RangeParseStrategy() {
            super(PATTERN);
        }

        @Override
        protected Set<Integer> doParse(Matcher matcher, String value) {
            int from = Integer.parseInt(matcher.group("from"));
            int to = Integer.parseInt(matcher.group("to"));
            return IntStream.rangeClosed(from, to).boxed().collect(Collectors.toSet());
        }
    }
}

