/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.testing.testcontainers.MongoDbShardedCluster;
import io.debezium.testing.testcontainers.util.DockerUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
public class MongoDbShardedClusterTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbShardedClusterTest.class);

    @BeforeAll
    static void setupAll() {
        DockerUtils.enableFakeDnsIfRequired();
    }

    @AfterAll
    static void tearDownAll() {
        DockerUtils.disableFakeDns();
    }

    @Test
    public void testCluster() {
        try (MongoDbShardedCluster cluster = MongoDbShardedCluster.shardedCluster().shardCount(1).replicaCount(1).routerCount(1).build();){
            LOGGER.info("Starting {}...", (Object)cluster);
            cluster.start();
            ReadPreference readPreference = ReadPreference.primary();
            ConnectionString connectionString = new ConnectionString(cluster.getConnectionString() + "/?readPreference=" + readPreference.getName());
            LOGGER.info("Connecting to cluster: {}", (Object)connectionString);
            try (MongoClient client = MongoClients.create((ConnectionString)connectionString);){
                LOGGER.info("Connected to cluster: {}", (Object)client.getClusterDescription());
                String databaseName = "test";
                cluster.enableSharding(databaseName);
                String collectionName = "docs";
                cluster.shardCollection(databaseName, collectionName, "name");
                MongoDatabase database = client.getDatabase(databaseName);
                MongoDbShardedClusterTest.assertThatShards(client).hasSize(1);
                MongoCollection collection = database.getCollection(collectionName);
                int docCount = 10;
                IntStream.rangeClosed(1, docCount).mapToObj(i -> Document.parse((String)("{name:" + i + "}"))).forEach(arg_0 -> ((MongoCollection)collection).insertOne(arg_0));
                MongoDbShardedClusterTest.assertThatCollection((MongoCollection<Document>)collection).hasSize(docCount);
                cluster.addShard();
                MongoDbShardedClusterTest.assertThatShards(client).hasSize(2);
                cluster.removeShard();
                MongoDbShardedClusterTest.assertThatShards(client).hasSize(1);
            }
        }
    }

    private static ListAssert<Document> assertThatCollection(MongoCollection<Document> collection) {
        return Assertions.assertThat(StreamSupport.stream(collection.find().spliterator(), false).collect(Collectors.toList()));
    }

    private static ListAssert<Document> assertThatShards(MongoClient client) {
        return Assertions.assertThat((List)client.getDatabase("admin").runCommand((Bson)new BasicDBObject("listShards", (Object)1)).getList((Object)"shards", Document.class));
    }
}

