/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util;

import com.github.dockerjava.api.model.Info;
import io.debezium.testing.testcontainers.util.FakeDns;
import java.net.InetAddress;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;

public class DockerUtils {
    public static final String DOCKER_DESKTOP_LOG_SKIP_PROPERTY = "docker.desktop.log.skip";
    public static final String DOCKER_DESKTOP_DISABLE_FAKE_DNS = "docker.desktop.disable.fake.dns";

    public static boolean isDockerDesktop() {
        Info info = DockerClientFactory.instance().getInfo();
        return "docker-desktop".equals(info.getName());
    }

    public static void logDockerDesktopBanner(Logger logger, Collection<String> hosts, boolean skip) {
        String prop = System.getProperty(DOCKER_DESKTOP_LOG_SKIP_PROPERTY, "false");
        boolean propertySkip = Boolean.parseBoolean(prop);
        if (propertySkip || skip || !DockerUtils.isDockerDesktop() || FakeDns.getInstance().isInstalled()) {
            return;
        }
        String newLine = "\n> ";
        String doubleNewLine = "\n> ".repeat(2);
        String hostEntries = hosts.stream().map(host -> "127.0.0.1 " + host).collect(Collectors.joining("\n> "));
        StringBuilder banner = new StringBuilder().append("\n>>> DOCKER DESKTOP DETECTED <<<").append(doubleNewLine).append("Requires the following entries in /etc/hosts or equivalent of your platform").append(doubleNewLine).append(hostEntries).append("\n> ").append("\n>>> Missing entries will likely lead to failures");
        logger.warn(banner.toString());
    }

    public static void enableFakeDnsIfRequired() {
        String property = System.getProperty(DOCKER_DESKTOP_DISABLE_FAKE_DNS, "false");
        if (DockerUtils.isDockerDesktop() && !Boolean.parseBoolean(property)) {
            FakeDns.getInstance().install();
        }
    }

    public static void disableFakeDns() {
        FakeDns.getInstance().restore();
    }

    public static void addFakeDnsEntry(String hostname) {
        DockerUtils.addFakeDnsEntry(hostname, InetAddress.getLoopbackAddress());
    }

    public static void addFakeDnsEntry(String hostname, InetAddress address) {
        if (FakeDns.getInstance().isInstalled()) {
            FakeDns.getInstance().addResolution(hostname, address);
        }
    }

    public static void removeFakeDnsEntry(String hostname) {
        DockerUtils.removeFakeDnsEntry(hostname, InetAddress.getLoopbackAddress());
    }

    public static void removeFakeDnsEntry(String hostname, InetAddress address) {
        if (FakeDns.getInstance().isInstalled()) {
            FakeDns.getInstance().removeResolution(hostname, address);
        }
    }

    private DockerUtils() {
        throw new AssertionError((Object)"Should not be instantiated");
    }
}

