/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import java.io.IOException;
import java.io.InputStream;

public class Connector {
    private static final String NAME = "name";
    private static final String CONFIGURATION = "config";
    private final String name;
    private final ConnectorConfiguration configuration;
    private static final ObjectMapper mapper = new ObjectMapper();

    private Connector(String name, ConnectorConfiguration configuration) {
        this.name = name;
        this.configuration = configuration;
    }

    public static Connector fromJson(InputStream inputStream) {
        try {
            ObjectNode connectorConfiguration = (ObjectNode)mapper.readValue(inputStream, ObjectNode.class);
            String name = connectorConfiguration.get(NAME).asText();
            ConnectorConfiguration config = ConnectorConfiguration.from(connectorConfiguration.get(CONFIGURATION));
            return new Connector(name, config);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Connector from(String name, ConnectorConfiguration configuration) {
        return new Connector(name, configuration);
    }

    public void appendOrOverrideConfiguration(ConnectorConfiguration newConfiguration) {
        ObjectNode configurationNode = this.configuration.getConfiguration();
        ObjectNode newConfigurationNode = newConfiguration.getConfiguration();
        newConfigurationNode.fields().forEachRemaining(e -> configurationNode.set((String)e.getKey(), (JsonNode)e.getValue()));
    }

    public String toJson() {
        JsonNode conf = mapper.valueToTree((Object)this.configuration.getConfiguration());
        ObjectNode connector = mapper.createObjectNode();
        connector.put(NAME, this.name);
        connector.set(CONFIGURATION, conf);
        try {
            return mapper.writeValueAsString((Object)connector);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public static enum State {
        UNASSIGNED,
        RUNNING,
        PAUSED,
        FAILED,
        DESTROYED;

    }
}

