/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.postgresql;

import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.resources.ConnectorFactories;
import io.debezium.testing.system.tests.postgresql.PostgreSqlTests;
import io.debezium.testing.system.tools.databases.SqlDatabaseController;
import io.debezium.testing.system.tools.databases.postgresql.OcpPostgreSqlReplicaController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import java.sql.SQLException;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

public abstract class PostgreSqlOcpTests
extends PostgreSqlTests {
    public PostgreSqlOcpTests(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    @Test
    @Order(value=100)
    public void shouldStreamFromReplica(OcpPostgreSqlReplicaController replicaController, SqlDatabaseController primaryController) throws InterruptedException, IOException, SQLException {
        this.connectController.undeployConnector(this.connectorConfig.getConnectorName());
        ConnectorConfigBuilder connector = new ConnectorFactories(this.kafkaController).postgresql((SqlDatabaseController)replicaController, "replica-connector");
        this.connectController.deployConnector(connector);
        String topic = connector.getDbServerName() + ".inventory.customers";
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 8));
        this.insertCustomer(primaryController, "Arnold", "Test", "atest@test.com");
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 9));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "atest@test.com"));
    }
}

