/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.listeners;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespacePreparationListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespacePreparationListener.class);
    private OpenShiftClient client;
    private List<String> projectNames;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.client = OpenShiftUtils.createOcpClient();
        if (ConfigProperties.OCP_PROJECT_DBZ != null && this.isOcpAvailable()) {
            this.projectNames = List.of(ConfigProperties.OCP_PROJECT_DBZ, ConfigProperties.OCP_PROJECT_ORACLE, ConfigProperties.OCP_PROJECT_MONGO, ConfigProperties.OCP_PROJECT_DB2, ConfigProperties.OCP_PROJECT_MYSQL, ConfigProperties.OCP_PROJECT_POSTGRESQL, ConfigProperties.OCP_PROJECT_REGISTRY, ConfigProperties.OCP_PROJECT_SQLSERVER);
            this.validateSystemParameters();
            if (ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI) {
                this.prepareNamespaces();
            }
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (ConfigProperties.OCP_PROJECT_DBZ != null && ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI && this.isOcpAvailable()) {
            this.deleteNamespaces();
        }
        this.client.close();
    }

    private void prepareNamespaces() {
        LOGGER.info("Preparing namespaces");
        ClusterRoleBindingBuilder anyUidBindingBuilder = this.prepareAnyUidBindingBuilder();
        ClusterRoleBindingBuilder privilegedBindingBuilder = this.preparePrivilegedBindingBuilder();
        for (String project : this.projectNames) {
            this.processNamespace(project, anyUidBindingBuilder, privilegedBindingBuilder);
        }
        this.waitForDefaultServiceAccount();
        this.client.clusterRoleBindings().createOrReplace((Object)anyUidBindingBuilder.build());
        this.client.clusterRoleBindings().createOrReplace((Object)privilegedBindingBuilder.build());
    }

    private void waitForDefaultServiceAccount() {
        this.projectNames.forEach(name -> Awaitility.await().atMost(WaitConditions.scaled((long)1L), TimeUnit.MINUTES).pollInterval(1L, TimeUnit.SECONDS).until(() -> ((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(name)).withName("default")).get() != null));
    }

    private void processNamespace(String namespace, ClusterRoleBindingBuilder anyuidBuilder, ClusterRoleBindingBuilder privilegedBuilder) {
        if (((Resource)this.client.projects().withName(namespace)).get() == null) {
            this.client.projects().createOrReplace((Object)((ProjectBuilder)((ProjectBuilder)((ProjectBuilder)new ProjectBuilder().withKind("Project")).withApiVersion("project.openshift.io/v1")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(namespace)).build())).build());
        }
        this.addServiceAccountToClusterRoleBinding(namespace, anyuidBuilder);
        this.addServiceAccountToClusterRoleBinding(namespace, privilegedBuilder);
    }

    private void addServiceAccountToClusterRoleBinding(String saNamespace, ClusterRoleBindingBuilder bindingBuilder) {
        bindingBuilder.addNewSubjectLike(((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("SystemUser")).withName("default")).withNamespace(saNamespace)).build());
        bindingBuilder.withUserNames(new String[]{"system:serviceaccount:" + saNamespace + ":default"});
    }

    private void validateSystemParameters() {
        boolean namespacesExist;
        LOGGER.trace("Validating OCP namespace environment");
        Assertions.assertThat(this.projectNames).isNotEmpty();
        Assertions.assertThat((Object)this.client).isNotNull();
        boolean bl = namespacesExist = ((Resource)this.client.projects().withName(this.projectNames.get(0))).get() != null;
        if (!ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI && !namespacesExist) {
            throw new IllegalArgumentException("Should not prepare strimzi/namespace but namespace is missing");
        }
    }

    private ClusterRoleBindingBuilder prepareAnyUidBindingBuilder() {
        return (ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)new ClusterRoleBindingBuilder().withApiVersion("authorization.openshift.io/v1")).withKind("ClusterRoleBinding")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName("system:openshift:scc:anyuid")).build())).withRoleRef(((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName("system:openshift:scc:anyuid")).build());
    }

    private ClusterRoleBindingBuilder preparePrivilegedBindingBuilder() {
        return (ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)new ClusterRoleBindingBuilder().withApiVersion("authorization.openshift.io/v1")).withKind("ClusterRoleBinding")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName("system:openshift:scc:privileged")).build())).withRoleRef(((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName("system:openshift:scc:privileged")).build());
    }

    private void deleteNamespaces() {
        LOGGER.info("Cleaning namespaces");
        this.projectNames.forEach(name -> {
            Project project = (Project)((Resource)this.client.projects().withName(name)).get();
            if (project != null) {
                this.client.projects().delete((Object)project);
            }
        });
    }

    private boolean isOcpAvailable() {
        block2: {
            try {
                this.client.getVersion();
            }
            catch (KubernetesClientException e) {
                if (!(e.getCause() instanceof UnknownHostException)) break block2;
                return false;
            }
        }
        return true;
    }
}

