/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.mongodb.sharded;

import com.mongodb.client.model.Filters;
import freemarker.template.TemplateException;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.tests.ConnectorTest;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardKey;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoReplicaSet;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedController;
import io.debezium.testing.system.tools.databases.mongodb.sharded.ShardKeyRange;
import io.debezium.testing.system.tools.databases.mongodb.sharded.componentproviders.OcpShardModelProvider;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class ShardedMongoTests
extends ConnectorTest {
    public ShardedMongoTests(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    public void insertCustomer(MongoDatabaseController dbController, String firstName, String lastName, String email, long id) {
        MongoDatabaseClient client = (MongoDatabaseClient)dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_USERNAME, ConfigProperties.DATABASE_MONGO_SA_PASSWORD);
        KafkaAssertions.LOGGER.info("Creating customer: " + email);
        client.execute(ConfigProperties.DATABASE_MONGO_DBZ_DBNAME, "customers", col -> {
            Document doc = new Document().append("_id", (Object)id).append("first_name", (Object)firstName).append("last_name", (Object)lastName).append("email", (Object)email);
            col.insertOne((Object)doc);
        });
    }

    public void removeCustomer(MongoDatabaseController dbController, String email) {
        MongoDatabaseClient client = (MongoDatabaseClient)dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_USERNAME, ConfigProperties.DATABASE_MONGO_SA_PASSWORD);
        client.execute("inventory", "customers", col -> {
            Bson query = Filters.eq((String)"email", (Object)email);
            col.deleteOne((Bson)col.find(query).first());
        });
    }

    public void removeProduct(MongoDatabaseController dbController, String name) {
        MongoDatabaseClient client = (MongoDatabaseClient)dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_USERNAME, ConfigProperties.DATABASE_MONGO_SA_PASSWORD);
        client.execute("inventory", "products", col -> {
            Bson query = Filters.eq((String)"name", (Object)name);
            col.deleteOne((Bson)col.find(query).first());
        });
    }

    public void insertProduct(MongoDatabaseController dbController, String name, String description, String weight, int quantity) {
        MongoDatabaseClient client = (MongoDatabaseClient)dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_USERNAME, ConfigProperties.DATABASE_MONGO_SA_PASSWORD);
        client.execute(ConfigProperties.DATABASE_MONGO_DBZ_DBNAME, "products", col -> {
            Document doc = new Document().append("name", (Object)name).append("description", (Object)description).append("weight", (Object)weight).append("quantity", (Object)quantity);
            col.insertOne((Object)doc);
        });
    }

    protected void addAndRemoveShardTest(OcpMongoShardedController dbController, String connectorName) throws IOException, InterruptedException, TemplateException {
        String topic = connectorName + ".inventory.customers";
        MongoShardKey key = dbController.getMongo().getShardKey("inventory.customers");
        ShardKeyRange keyRange = new ShardKeyRange(OcpShardModelProvider.getShardReplicaSetName((int)3), "1100", "1105");
        OcpMongoReplicaSet newShard = dbController.getMongo().addShard(Map.of(key, keyRange));
        newShard.executeMongosh(dbController.createDbzUserCommand(), false);
        this.connectController.undeployConnector(connectorName);
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((MongoDatabaseController)dbController, "Filip", "Foobar", "ffoo@test.com", 1101L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ffoo@test.com"));
        this.removeCustomer((MongoDatabaseController)dbController, "ffoo@test.com");
        dbController.getMongo().removeShard();
        this.connectController.undeployConnector(connectorName);
        this.connectController.deployConnector(this.connectorConfig);
    }
}

