/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.registry;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.assertions.AvroKafkaAssertions;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaConnectBuilder;
import io.debezium.testing.system.tools.registry.ApicurioOperatorController;
import io.debezium.testing.system.tools.registry.OcpApicurioController;
import io.debezium.testing.system.tools.registry.OcpApicurioDeployer;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.debezium.testing.system.tools.registry.builders.FabricApicurioBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixtureContext(requires={OpenShiftClient.class, KafkaController.class, ApicurioOperatorController.class}, provides={RegistryController.class}, overrides={KafkaAssertions.class})
public class OcpApicurio
extends TestFixture {
    private final OpenShiftClient ocp = (OpenShiftClient)this.retrieve(OpenShiftClient.class);
    private final KafkaController kafkaController = (KafkaController)this.retrieve(KafkaController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurio.class);

    public OcpApicurio(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() throws Exception {
        String kafkaAddress = this.kafkaController.getBootstrapAddress();
        if (ConfigProperties.APICURIO_TLS_ENABLED) {
            LOGGER.info("Apicurio TLS enabled");
            this.prepareCertificateSecrets();
            kafkaAddress = this.kafkaController.getTlsBootstrapAddress();
        }
        FabricApicurioBuilder fabricBuilder = FabricApicurioBuilder.baseKafkaSql((String)kafkaAddress);
        OcpApicurioDeployer deployer = new OcpApicurioDeployer(ConfigProperties.OCP_PROJECT_REGISTRY, fabricBuilder, this.ocp, new OkHttpClient());
        OcpApicurioController controller = deployer.deploy();
        this.store(RegistryController.class, controller);
        this.store(KafkaAssertions.class, new AvroKafkaAssertions(this.kafkaController.getDefaultConsumerProperties()));
    }

    public void teardown() {
        LOGGER.debug("Skipping apicurio tear down");
    }

    private void prepareCertificateSecrets() {
        LOGGER.debug("Copying Kafka certificate secrets to Apicurio namespace");
        Secret kafkaSecret = (Secret)((Resource)((NonNamespaceOperation)this.ocp.secrets().inNamespace(ConfigProperties.OCP_PROJECT_DBZ)).withName(FabricKafkaConnectBuilder.KAFKA_CERT_SECRET)).get();
        Map kafkaClientSecretData = ((Secret)((Resource)((NonNamespaceOperation)this.ocp.secrets().inNamespace(ConfigProperties.OCP_PROJECT_DBZ)).withName(FabricKafkaConnectBuilder.KAFKA_CLIENT_CERT_SECRET)).get()).getData();
        Secret secretNewMetadata = ((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder(kafkaSecret).withNewMetadata().withNamespace(ConfigProperties.OCP_PROJECT_REGISTRY)).withName(FabricKafkaConnectBuilder.KAFKA_CERT_SECRET)).endMetadata()).build();
        Secret clientSecretRenamedCerts = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withNamespace(ConfigProperties.OCP_PROJECT_REGISTRY)).withName(FabricKafkaConnectBuilder.KAFKA_CLIENT_CERT_SECRET)).endMetadata()).addToData("user.p12", (String)kafkaClientSecretData.get("ca.p12"))).addToData("user.password", (String)kafkaClientSecretData.get("ca.password"))).build();
        ((NonNamespaceOperation)this.ocp.secrets().inNamespace(ConfigProperties.OCP_PROJECT_REGISTRY)).createOrReplace((Object)secretNewMetadata);
        ((NonNamespaceOperation)this.ocp.secrets().inNamespace(ConfigProperties.OCP_PROJECT_REGISTRY)).createOrReplace((Object)clientSecretRenamedCerts);
    }
}

