/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.databases.ocp;

import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.fixtures.databases.ocp.OcpDatabaseFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardedUtil;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedController;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedDeployer;
import io.fabric8.openshift.client.OpenShiftClient;
import org.junit.jupiter.api.extension.ExtensionContext;

@FixtureContext(requires={OpenShiftClient.class}, provides={OcpMongoShardedController.class})
public class OcpMongoSharded
extends OcpDatabaseFixture<OcpMongoShardedController> {
    private OcpMongoShardedController controller;

    public OcpMongoSharded(ExtensionContext.Store store) {
        super(OcpMongoShardedController.class, store);
    }

    @Override
    protected OcpMongoShardedController databaseController() throws Exception {
        OcpMongoShardedDeployer deployer = OcpMongoShardedDeployer.builder().withProject(ConfigProperties.OCP_PROJECT_MONGO).withOcp(this.ocp).withConfigServerCount(3).withShardCount(2).withReplicaCount(3).withShardKeys(MongoShardedUtil.getTestShardKeys()).withUseKeyfile(ConfigProperties.DATABASE_MONGO_USE_KEYFILE).withUseTls(ConfigProperties.DATABASE_MONGO_USE_TLS).withRootUser(ConfigProperties.DATABASE_MONGO_USERNAME, ConfigProperties.DATABASE_MONGO_SA_PASSWORD).build();
        this.controller = deployer.deploy();
        return this.controller;
    }

    @Override
    public void teardown() throws Exception {
        this.controller.getMongo().stop();
        this.controller.getMongo().waitForStopped();
    }
}

