/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.operatorutil;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.fabric8.FabricBuilderWrapper;
import io.debezium.testing.system.tools.kafka.builders.StrimziSubscriptionBuilder;
import io.debezium.testing.system.tools.operatorutil.OpenshiftOperatorEnum;
import io.debezium.testing.system.tools.registry.builders.ApicurioSubscriptionBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;

public class OperatorUtil {
    public static void deployOperator(OpenShiftClient ocp, OpenshiftOperatorEnum operatorEnum, String namespace) throws InterruptedException {
        OpenShiftUtils utils = new OpenShiftUtils(ocp);
        utils.createOrReplaceOperatorGroup(namespace, operatorEnum.getOperatorGroupName());
        FabricBuilderWrapper sb = operatorEnum == OpenshiftOperatorEnum.STRIMZI ? StrimziSubscriptionBuilder.base() : ApicurioSubscriptionBuilder.base();
        if (ConfigProperties.PRODUCT_BUILD) {
            sb.withProductConfig();
        } else {
            sb.withCommunityConfig();
        }
        sb.withChannel(operatorEnum.getSubscriptionUpdateChannel()).withNamespace(namespace);
        ((NonNamespaceOperation)ocp.operatorHub().subscriptions().inNamespace(namespace)).createOrReplace((Object)sb.build());
        utils.waitForOperatorDeploymentExists(namespace, operatorEnum);
    }
}

