/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.mongodb.sharded;

import fixture5.FixtureExtension;
import fixture5.annotations.Fixture;
import freemarker.template.TemplateException;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.connectors.ShardedReplicaMongoConnector;
import io.debezium.testing.system.fixtures.databases.ocp.OcpMongoSharded;
import io.debezium.testing.system.fixtures.kafka.OcpKafka;
import io.debezium.testing.system.fixtures.operator.OcpStrimziOperator;
import io.debezium.testing.system.tests.mongodb.sharded.ShardedMongoTests;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tag(value="mongo-sharded-replicaset")
@Fixture.Container(value={@Fixture(value=OcpClient.class), @Fixture(value=OcpStrimziOperator.class), @Fixture(value=OcpKafka.class), @Fixture(value=OcpMongoSharded.class), @Fixture(value=ShardedReplicaMongoConnector.class)})
@ExtendWith(value={FixtureExtension.class})
public class OcpShardedReplicaMongoConnectorIT
extends ShardedMongoTests {
    public OcpShardedReplicaMongoConnectorIT(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    @Test
    public void shouldStreamInReplicaSetMode(OcpMongoShardedController dbController) throws IOException, InterruptedException, TemplateException {
        String topic = this.connectorConfig.getConnectorName() + ".inventory.customers";
        this.assertions.assertTopicsExist(topic, this.connectorConfig.getConnectorName() + ".inventory.products");
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 4));
        this.insertCustomer((MongoDatabaseController)dbController, "Eve", "Sharded", "eshard@test.com", 1007L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "eshard@test.com"));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertMinimalRecordsCount(topic, 5));
        this.insertProduct((MongoDatabaseController)dbController, "replicaset product", "demonstrates that replicaset connector mode works", "12.5", 3);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(this.connectorConfig.getConnectorName() + ".inventory.products", "replicaset product"));
        this.addAndRemoveShardTest(dbController, this.connectorConfig.getConnectorName());
        this.insertCustomer((MongoDatabaseController)dbController, "Eric", "Eh", "ee@test.com", 1008L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ee@test.com"));
    }
}

