/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.databases.ocp;

import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.assertions.JdbcAssertions;
import io.debezium.testing.system.fixtures.databases.ocp.OcpDatabaseFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.SqlDatabaseController;
import io.debezium.testing.system.tools.databases.mysql.MySqlController;
import io.debezium.testing.system.tools.databases.mysql.OcpMySqlDeployer;
import io.fabric8.openshift.client.OpenShiftClient;
import org.junit.jupiter.api.extension.ExtensionContext;

@FixtureContext(requires={OpenShiftClient.class}, provides={MySqlController.class, JdbcAssertions.class})
public class OcpMySql
extends OcpDatabaseFixture<MySqlController> {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/mysql/master/master-deployment.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/mysql/master/master-service.yaml";
    private static final String DB_VOLUME_CLAIM_PATH = "/database-resources/mysql/master/volume-claim.yml";

    public OcpMySql(ExtensionContext.Store store) {
        super(MySqlController.class, store);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.store(JdbcAssertions.class, new JdbcAssertions((SqlDatabaseController)this.dbController));
    }

    @Override
    protected MySqlController databaseController() throws Exception {
        Class.forName("com.mysql.cj.jdbc.Driver");
        OcpMySqlDeployer deployer = ((OcpMySqlDeployer.Deployer)((OcpMySqlDeployer.Deployer)((OcpMySqlDeployer.Deployer)((OcpMySqlDeployer.Deployer)((OcpMySqlDeployer.Deployer)new OcpMySqlDeployer.Deployer().withOcpClient(this.ocp)).withProject(ConfigProperties.OCP_PROJECT_MYSQL)).withDeployment(DB_DEPLOYMENT_PATH)).withVolumeClaim(DB_VOLUME_CLAIM_PATH).withPullSecrets((String)ConfigProperties.OCP_PULL_SECRET_PATH.get())).withServices(new String[]{DB_SERVICE_PATH})).build();
        return deployer.deploy();
    }
}

