/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.databases.docker;

import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.fixtures.databases.docker.DockerDatabaseFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.mongodb.DockerMongoController;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.testing.testcontainers.util.ParsingPortResolver;
import io.debezium.testing.testcontainers.util.PortResolver;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.Network;

@FixtureContext(requires={Network.class}, provides={MongoDatabaseController.class})
public class DockerMongo
extends DockerDatabaseFixture<MongoDatabaseController> {
    private MongoDbReplicaSet mongo;

    public DockerMongo(ExtensionContext.Store store) {
        super(MongoDatabaseController.class, store);
    }

    @Override
    protected MongoDatabaseController databaseController() throws Exception {
        ParsingPortResolver portResolver = new ParsingPortResolver(ConfigProperties.DATABASE_MONGO_DOCKER_DESKTOP_PORTS);
        this.mongo = MongoDbReplicaSet.replicaSet().memberCount(ConfigProperties.DATABASE_MONGO_DOCKER_REPLICA_SIZE).portResolver((PortResolver)portResolver).network(this.network).authEnabled(true).rootUser(ConfigProperties.DATABASE_MONGO_USERNAME, ConfigProperties.DATABASE_MONGO_SA_PASSWORD).build();
        DockerUtils.enableFakeDnsIfRequired();
        this.mongo.start();
        return new DockerMongoController(this.mongo);
    }

    @Override
    public void teardown() throws Exception {
        this.mongo.stop();
        DockerUtils.disableFakeDns();
    }
}

