/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.assertions;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.SqlDatabaseClient;
import io.debezium.testing.system.tools.databases.SqlDatabaseController;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAssertions {
    SqlDatabaseController databaseController;
    Logger LOGGER = LoggerFactory.getLogger(JdbcAssertions.class);

    public static void awaitAssert(ThrowingRunnable assertion) {
        Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.SECONDS).atMost(WaitConditions.scaled((long)1L), TimeUnit.MINUTES).untilAsserted(assertion);
    }

    public JdbcAssertions(SqlDatabaseController databaseController) {
        this.databaseController = databaseController;
    }

    public void assertRowsCount(int expectedCount, String table) throws SQLException {
        SqlDatabaseClient client = this.databaseController.getDatabaseClient(ConfigProperties.DATABASE_MYSQL_USERNAME, ConfigProperties.DATABASE_MYSQL_PASSWORD);
        String sql = "SELECT count(*) FROM " + table;
        int databaseCount = (Integer)client.executeQuery("inventory", sql, rs -> {
            try {
                rs.next();
                return rs.getInt(1);
            }
            catch (SQLException e) {
                throw new AssertionError((Object)e);
            }
        });
        ((AbstractIntegerAssert)Assertions.assertThat((int)databaseCount).withFailMessage("Expecting table '%s' to have <%d> rows but it had <%d>.", new Object[]{table, expectedCount, databaseCount})).isEqualTo(expectedCount);
    }

    public void assertRowsContain(String table, String column, String content) throws SQLException {
        SqlDatabaseClient client = this.databaseController.getDatabaseClient(ConfigProperties.DATABASE_MYSQL_USERNAME, ConfigProperties.DATABASE_MYSQL_PASSWORD);
        String sql = String.format("SELECT * FROM %s WHERE %s = \"%s\"", table, column, content);
        boolean containsContent = (Boolean)client.executeQuery("inventory", sql, rs -> {
            try {
                return rs.next();
            }
            catch (SQLException e) {
                throw new AssertionError((Object)e);
            }
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)containsContent).withFailMessage("Table '%s' does not contain row with column '%s' containing <%s>.", new Object[]{table, column, content})).isTrue();
    }
}

