/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.databases.DatabaseClient;
import io.debezium.testing.system.tools.databases.DatabaseController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcpDatabaseController<C extends DatabaseClient<?, ?>>
implements DatabaseController<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpDatabaseController.class);
    protected final OpenShiftClient ocp;
    protected final String project;
    protected final OpenShiftUtils ocpUtils;
    protected Deployment deployment;
    protected String name;
    protected List<Service> services;

    public AbstractOcpDatabaseController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.name = deployment.getMetadata().getName();
        this.project = deployment.getMetadata().getNamespace();
        this.services = services;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    private Service getService() {
        return (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName())).get();
    }

    @Override
    public void reload() throws InterruptedException {
        LOGGER.info("Removing all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        this.ocpUtils.scaleDeploymentToZero(this.deployment);
        LOGGER.info("Restoring all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).scale(1);
    }

    @Override
    public String getDatabaseHostname() {
        return this.getService().getMetadata().getName() + "." + this.project + ".svc.cluster.local";
    }

    @Override
    public int getDatabasePort() {
        return this.getOriginalDatabasePort();
    }

    @Override
    public String getPublicDatabaseHostname() {
        return this.getDatabaseHostname();
    }

    @Override
    public int getPublicDatabasePort() {
        return this.getDatabasePort();
    }

    private int getOriginalDatabasePort() {
        return this.getService().getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
    }
}

